package ru.yandex.direct.jobs.redirects;

import com.fasterxml.jackson.annotation.JsonProperty;

public class RedirectCacheRecord {
    @JsonProperty("href")
    private String href;

    @JsonProperty("redirectUrl")
    private String redirectUrl;

    @JsonProperty("redirectDomain")
    private String redirectDomain;

    public String getHref() {
        return href;
    }

    public RedirectCacheRecord withHref(String href) {
        this.href = href;
        return this;
    }

    public String getRedirectUrl() {
        return redirectUrl;
    }

    public RedirectCacheRecord withRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    public String getRedirectDomain() {
        return redirectDomain;
    }

    public RedirectCacheRecord withRedirectDomain(String redirectDomain) {
        this.redirectDomain = redirectDomain;
        return this;
    }
}

