package ru.yandex.direct.jobs.redirects;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod;
import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.env.NonDevelopmentEnvironment;
import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification;
import ru.yandex.direct.juggler.check.model.NotificationRecipient;
import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.scheduler.support.DirectShardedJob;

import static ru.yandex.direct.common.db.PpcPropertyNames.TRUST_REDIRECT_FROM_ANY_DOMAIN;
import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_0;

/**
 * Обновление домена в баннере на основе ссылки после редиректов
 */
@JugglerCheck(ttl = @JugglerCheck.Duration(hours = 1),
        needCheck = NonDevelopmentEnvironment.class,
        notifications = @OnChangeNotification(
                recipient = NotificationRecipient.LOGIN_MAXLOG,
                method = NotificationMethod.TELEGRAM,
                status = {JugglerStatus.OK, JugglerStatus.WARN, JugglerStatus.CRIT}), tags = {DIRECT_PRIORITY_0})
@Hourglass(periodInSeconds = 60, needSchedule = NonDevelopmentEnvironment.class)
public class RedirectCheckJob extends DirectShardedJob {

    private static final Logger logger = LoggerFactory.getLogger(RedirectCheckJob.class);

    private final RedirectCheckService redirectCheckService;
    private final PpcPropertiesSupport ppcPropertiesSupport;

    @Autowired
    public RedirectCheckJob(
            RedirectCheckService redirectCheckService,
            PpcPropertiesSupport ppcPropertiesSupport
    ) {
        this.redirectCheckService = redirectCheckService;
        this.ppcPropertiesSupport = ppcPropertiesSupport;
    }

    @Override
    public void execute() {
        boolean trustRedirectFromAnyDomain = ppcPropertiesSupport.get(TRUST_REDIRECT_FROM_ANY_DOMAIN)
                .getOrDefault(false);

        int shard = getShard();
        redirectCheckService.processQueue(shard, trustRedirectFromAnyDomain);
    }
}
