package ru.yandex.direct.jobs.resendblockeddomains.model;

import java.util.Objects;

public class BadDomainsTitle {
    private final long id;
    private final String domain;
    private final BadDomainsTitleStatus status;

    public BadDomainsTitle(long id, String domain, BadDomainsTitleStatus status) {
        this.id = id;
        this.domain = domain;
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BadDomainsTitle that = (BadDomainsTitle) o;
        return id == that.id &&
                Objects.equals(domain, that.domain) &&
                status == that.status;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, domain, status);
    }

    public long getId() {
        return id;
    }

    public String getDomain() {
        return domain;
    }

    public BadDomainsTitleStatus getStatus() {
        return status;
    }
}
