package ru.yandex.direct.jobs.resendblockeddomains.model;

import ru.yandex.direct.dbschema.ppcdict.enums.BadDomainsTitlesStatus;

public enum BadDomainsTitleStatus {
    PROCESSED("processed"),
    FOR_DISABLING("for_disabling"),
    FOR_ENABLING("for_enabling");

    private final String literal;

    BadDomainsTitleStatus(String literal) {
        this.literal = literal;
    }

    public String getLiteral() {
        return literal;
    }

    public static BadDomainsTitleStatus fromSource(BadDomainsTitlesStatus value) {
        if (value  == null) {
            return null;
        }
        switch (value) {
            case for_disabling:
                return FOR_DISABLING;
            case for_enabling:
                return FOR_ENABLING;
            case processed:
                return PROCESSED;
            default:
                throw new IllegalStateException("No such status for bad_domain_titles:" + value);
        }
    }
}
