package ru.yandex.direct.jobs.segment.common;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.jobs.base.logdatatransfer.MetricsProvider;
import ru.yandex.direct.jobs.segment.common.result.SegmentUpdateResult;
import ru.yandex.direct.solomon.SolomonPushClient;
import ru.yandex.direct.solomon.SolomonPushClientException;
import ru.yandex.direct.solomon.SolomonUtils;

public class SegmentMetricsProvider implements MetricsProvider<SegmentUpdateResult> {

    private static final Logger logger = LoggerFactory.getLogger(SegmentMetricsProvider.class);

    private final SolomonPushClient solomonPushClient;
    private final String solomonLabel;

    private int successfullyUpdatedSegments = 0;
    private int segmentsFailedToUpdate = 0;

    public SegmentMetricsProvider(SolomonPushClient solomonPushClient, String solomonLabel) {
        this.solomonPushClient = solomonPushClient;
        this.solomonLabel = solomonLabel;
    }

    @Override
    public void addResult(SegmentUpdateResult result) {
        successfullyUpdatedSegments += result.getSegmentKeyToUploadResult().size();
        segmentsFailedToUpdate += result.getSegmentKeysOfFailedUploads().size();
    }

    @Override
    public void sendMonitoringInfo(int shard) {
        var registry = SolomonUtils.newPushRegistry("flow", solomonLabel, "shard", String.valueOf(shard));
        registry.gaugeInt64("items_upload_all_count").set(successfullyUpdatedSegments + segmentsFailedToUpdate);
        registry.gaugeInt64("items_upload_error_count").set(segmentsFailedToUpdate);
        try {
            solomonPushClient.sendMetrics(registry);
        } catch (SolomonPushClientException e) {
            logger.error("Got exception on sending metrics", e);
        }
    }
}
