package ru.yandex.direct.jobs.segment.common;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.function.Function;

import ru.yandex.direct.core.entity.adgroup.model.UsersSegment;
import ru.yandex.direct.jobs.segment.common.meta.SegmentKey;
import ru.yandex.direct.ytwrapper.client.YtClusterConfig;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.model.YtCluster;
import ru.yandex.direct.ytwrapper.model.YtOperator;
import ru.yandex.direct.ytwrapper.model.YtSQLSyntaxVersion;

import static ru.yandex.direct.jobs.util.yt.YtEnvPath.relativePart;
import static ru.yandex.direct.ytwrapper.YtPathUtil.generatePath;

public class SegmentUtils {

    public static final YtCluster SEGMENTS_CLUSTER = YtCluster.HAHN;

    public static final int ITERATION_SEGMENTS_LIMIT = 100;

    public static final String ROW_COUNT_ATTRIBUTE_NAME = "row_count";

    private static final String BS_CHEVENT_LOG_PATH = "//cooked_logs/bs-chevent-cooked-log/1d/";

    public static YtOperator getYtOperator(YtProvider ytProvider, YtCluster ytCluster) {
        return ytProvider.getOperator(ytCluster, YtSQLSyntaxVersion.SQLv1);
    }

    public static Function<UsersSegment, SegmentKey> segmentKeyExtractor() {
        return segment -> new SegmentKey(segment.getAdGroupId(), segment.getType());
    }

    public static Function<LocalDate, String> commonLogPathProvider() {
        return date -> BS_CHEVENT_LOG_PATH + DateTimeFormatter.ISO_LOCAL_DATE.format(date);
    }

    public static Function<LocalDate, String> intermediateTablePathProvider(String tableRootPath) {
        return date -> generatePath(tableRootPath, DateTimeFormatter.ISO_LOCAL_DATE.format(date));
    }

    public static String intermediateTableRootPath(YtProvider ytProvider, String tablePath) {
        YtClusterConfig ytClusterConfig = ytProvider.getClusterConfig(SEGMENTS_CLUSTER);
        return generatePath(ytClusterConfig.getHome(), relativePart(), tablePath);
    }
}
