package ru.yandex.direct.jobs.segment.common.meta;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.UsersSegment;
import ru.yandex.direct.core.entity.userssegments.repository.UsersSegmentRepository;
import ru.yandex.direct.jobs.base.logdatatransfer.MetaFetchingStrategy;

public class CreatingSegmentMetaFetchingStrategy implements MetaFetchingStrategy<UsersSegment> {

    private static final Logger logger = LoggerFactory.getLogger(CreatingSegmentMetaFetchingStrategy.class);

    private final UsersSegmentRepository usersSegmentRepository;
    private final AdGroupType adGroupType;

    public CreatingSegmentMetaFetchingStrategy(UsersSegmentRepository usersSegmentRepository,
                                               AdGroupType adGroupType) {
        this.usersSegmentRepository = usersSegmentRepository;
        this.adGroupType = adGroupType;
    }

    @Override
    public List<UsersSegment> fetch(int shard, int limit) {
        List<UsersSegment> usersSegments =
                usersSegmentRepository.getOldestSegmentsForCreate(shard, adGroupType, limit);
        logger.info("fetched {} segments meta for creating segments with oldest log read date", usersSegments.size());
        return usersSegments;
    }
}
