package ru.yandex.direct.jobs.segment.common.meta;

import java.util.Objects;

import ru.yandex.direct.core.entity.adgroup.model.AdShowType;

import static com.google.common.base.Preconditions.checkNotNull;

public class SegmentKey {

    private final Long adGroupId;
    private final AdShowType segmentType;

    public SegmentKey(Long adGroupId, AdShowType segmentType) {
        checkNotNull(adGroupId, "adGroupId");
        checkNotNull(segmentType, "segmentType");
        this.adGroupId = adGroupId;
        this.segmentType = segmentType;
    }

    public static SegmentKey segmentKey(Long adGroupId, AdShowType segmentType) {
        return new SegmentKey(adGroupId, segmentType);
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public AdShowType getSegmentType() {
        return segmentType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SegmentKey that = (SegmentKey) o;
        return adGroupId.equals(that.adGroupId) &&
                segmentType == that.segmentType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(adGroupId, segmentType);
    }

    @Override
    public String toString() {
        return "SegmentKey{" +
                "adGroupId=" + adGroupId +
                ", segmentType=" + segmentType +
                '}';
    }
}
