package ru.yandex.direct.jobs.segment.common.meta;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.userssegments.repository.UsersSegmentRepository;

@Component
public class SegmentMetaFetchingStrategyFactory {

    private final UsersSegmentRepository usersSegmentRepository;

    @Autowired
    public SegmentMetaFetchingStrategyFactory(UsersSegmentRepository usersSegmentRepository) {
        this.usersSegmentRepository = usersSegmentRepository;
    }

    public UpdatingSegmentMetaFetchingStrategy createFetchingStrategyForUpdateSegments(AdGroupType adGroupType) {
        return new UpdatingSegmentMetaFetchingStrategy(usersSegmentRepository, adGroupType);
    }

    public CreatingSegmentMetaFetchingStrategy createFetchingStrategyForCreateSegments(AdGroupType adGroupType) {
        return new CreatingSegmentMetaFetchingStrategy(usersSegmentRepository, adGroupType);
    }
}
