package ru.yandex.direct.jobs.segment.common.preprocessor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

import com.google.common.collect.ImmutableList;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jobs.segment.common.metrica.UploadSegmentsService;

@Component
public class FakeUidsHolder {

    private final List<BigInteger> fakeUids;

    public FakeUidsHolder() {
        fakeUids = ImmutableList.copyOf(readFakeData());
    }

    private List<BigInteger> readFakeData() {
        try (InputStream stream = UploadSegmentsService.class.getClassLoader()
                .getResourceAsStream("videogoals/fake_data.tsv")) {
            InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
            BufferedReader breader = new BufferedReader(reader);
            List<BigInteger> list = new ArrayList<>();
            String line = breader.readLine();
            while (line != null) {
                list.add(new BigInteger(line));
                line = breader.readLine();
            }
            return list;
        } catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public List<BigInteger> getFakeUids() {
        return fakeUids;
    }
}
