package ru.yandex.direct.jobs.segment.common.result;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import ru.yandex.direct.jobs.segment.common.meta.SegmentKey;

public class SegmentUpdateResult {

    private Map<SegmentKey, SegmentUploadResult> segmentKeyToUploadResult;
    private Set<SegmentKey> segmentKeysOfFailedUploads;

    public SegmentUpdateResult() {
        this(new HashMap<>(), new HashSet<>());
    }

    public SegmentUpdateResult(Map<SegmentKey, SegmentUploadResult> segmentKeyToUploadResult,
                               Set<SegmentKey> segmentKeysOfFailedUploads) {
        this.segmentKeyToUploadResult = segmentKeyToUploadResult;
        this.segmentKeysOfFailedUploads = segmentKeysOfFailedUploads;
    }

    public void segmentUploadedSuccessfully(SegmentKey segmentKey, SegmentUploadResult segmentUploadResult) {
        segmentKeyToUploadResult.put(segmentKey, segmentUploadResult);
    }

    public void segmentUploadFailed(SegmentKey segmentKey) {
        segmentKeysOfFailedUploads.add(segmentKey);
    }

    public Map<SegmentKey, SegmentUploadResult> getSegmentKeyToUploadResult() {
        return segmentKeyToUploadResult;
    }

    public Set<SegmentKey> getSegmentKeysOfFailedUploads() {
        return segmentKeysOfFailedUploads;
    }
}
