package ru.yandex.direct.jobs.segment.common.result;

import java.util.Objects;

import ru.yandex.direct.core.entity.adgroup.model.ExternalAudienceStatus;

public class SegmentUploadResult {

    private final Long segmentOwnerUid;
    private final Long externalAudienceId;
    private final ExternalAudienceStatus externalAudienceStatus;

    public SegmentUploadResult(Long segmentOwnerUid, Long externalAudienceId,
                               ExternalAudienceStatus externalAudienceStatus) {
        this.segmentOwnerUid = segmentOwnerUid;
        this.externalAudienceId = externalAudienceId;
        this.externalAudienceStatus = externalAudienceStatus;
    }

    public ExternalAudienceStatus getExternalAudienceStatus() {
        return externalAudienceStatus;
    }

    public Long getSegmentOwnerUid() {
        return segmentOwnerUid;
    }

    public Long getExternalAudienceId() {
        return externalAudienceId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SegmentUploadResult that = (SegmentUploadResult) o;
        return Objects.equals(segmentOwnerUid, that.segmentOwnerUid) &&
                Objects.equals(externalAudienceId, that.externalAudienceId) &&
                externalAudienceStatus == that.externalAudienceStatus;
    }

    @Override
    public int hashCode() {
        return Objects.hash(segmentOwnerUid, externalAudienceId, externalAudienceStatus);
    }

    @Override
    public String toString() {
        return "SegmentUploadResult{" +
                "segmentOwnerUid=" + segmentOwnerUid +
                ", externalAudienceId=" + externalAudienceId +
                ", externalAudienceStatus=" + externalAudienceStatus +
                '}';
    }
}
