package ru.yandex.direct.jobs.segment.common.target;

import java.math.BigInteger;
import java.util.Set;

import ru.yandex.direct.audience.client.model.SegmentContentType;
import ru.yandex.direct.core.entity.adgroup.model.UsersSegment;
import ru.yandex.direct.core.entity.metrika.model.Segment;
import ru.yandex.direct.core.entity.user.repository.UserRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.jobs.segment.common.metrica.UploadSegmentsService;
import ru.yandex.direct.jobs.segment.common.result.SegmentUploadResult;
import ru.yandex.direct.jobs.segment.common.target.name.SegmentNameHelper;

public class CreateYaAudienceSegmentUploadStrategy implements YaAudienceSegmentUploadStrategy {

    private final UserRepository userRepository;
    private final SegmentNameHelper segmentNameHelper;
    private final UploadSegmentsService uploadSegmentsService;
    private final ShardHelper shardHelper;

    public CreateYaAudienceSegmentUploadStrategy(UserRepository userRepository,
                                                 SegmentNameHelper segmentNameHelper,
                                                 UploadSegmentsService uploadSegmentsService,
                                                 ShardHelper shardHelper) {
        this.userRepository = userRepository;
        this.segmentNameHelper = segmentNameHelper;
        this.uploadSegmentsService = uploadSegmentsService;
        this.shardHelper = shardHelper;
    }

    @Override
    public SegmentUploadResult upload(UsersSegment segmentMeta, Set<BigInteger> uids, SegmentContentType contentType) {
        Long clientId = shardHelper.getClientIdByAdGroupId(segmentMeta.getAdGroupId());
        int shard = shardHelper.getShardByClientIdStrictly(ClientId.fromLong(clientId));
        Long segmentOwnerUid = userRepository.getChiefUidByClientId(shard, clientId);
        String mainUserLogin = shardHelper.getLoginByUid(segmentOwnerUid);

        segmentMeta.setSegmentOwnerUid(segmentOwnerUid);
        String segmentName = segmentNameHelper.getSegmentName(shard, segmentMeta);

        Segment segment = uploadSegmentsService.uploadUids(uids, mainUserLogin);
        Long segmentId = segment.getId();
        segment = uploadSegmentsService.confirm(segmentId, mainUserLogin, segmentName, contentType);

        return new SegmentUploadResult(segmentOwnerUid, segment.getId(), segment.getStatus());
    }
}
