package ru.yandex.direct.jobs.segment.common.target;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

import one.util.streamex.EntryStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.core.entity.adgroup.model.UsersSegment;
import ru.yandex.direct.jobs.base.logdatatransfer.TargetUpdatingStrategy;
import ru.yandex.direct.jobs.segment.common.meta.SegmentKey;
import ru.yandex.direct.jobs.segment.common.result.SegmentUpdateResult;
import ru.yandex.direct.jobs.segment.common.result.SegmentUploadResult;
import ru.yandex.direct.jobs.segment.log.SegmentSourceData;
import ru.yandex.direct.utils.InterruptedRuntimeException;

import static ru.yandex.direct.jobs.segment.common.SegmentUtils.segmentKeyExtractor;
import static ru.yandex.direct.utils.FunctionalUtils.listToMap;

public class SegmentTargetUpdatingStrategy
        implements TargetUpdatingStrategy<UsersSegment, SegmentSourceData, SegmentUpdateResult> {

    private static final Logger logger = LoggerFactory.getLogger(TargetUpdatingStrategy.class);

    private final YaAudienceSegmentUploadStrategy yaAudienceSegmentUploadStrategy;

    public SegmentTargetUpdatingStrategy(YaAudienceSegmentUploadStrategy yaAudienceSegmentUploadStrategy) {
        this.yaAudienceSegmentUploadStrategy = yaAudienceSegmentUploadStrategy;
    }

    @Override
    public SegmentUpdateResult updateTarget(List<UsersSegment> meta, SegmentSourceData sourceData) {
        SegmentUpdateResult result = new SegmentUpdateResult();
        if (!sourceData.wereLogsRead()) {
            logger.info("no new data for uploading, return");
            return result;
        }

        Map<SegmentKey, UsersSegment> segmentMetaMap = listToMap(meta, segmentKeyExtractor());

        EntryStream.of(sourceData.getSegmentKeyToUids())
                .removeValues(Set::isEmpty)
                .forKeyValue((segmentKey, uids) -> {

                    UsersSegment segmentMeta = segmentMetaMap.get(segmentKey);
                    logger.info("processing segment: {}; uids amount: {}, content type: {}",
                            segmentKey, uids.size(), sourceData.getContentType());

                    try {
                        SegmentUploadResult uploadResult =
                                yaAudienceSegmentUploadStrategy.upload(segmentMeta, uids, sourceData.getContentType());
                        logger.info("segment uploaded successfully: {}; " +
                                        "Ya.Audience id: {}" +
                                        "Ya.Audience status: {};",
                                segmentKey, uploadResult.getExternalAudienceId(),
                                uploadResult.getExternalAudienceStatus());
                        result.segmentUploadedSuccessfully(segmentKey, uploadResult);
                    } catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        throw new InterruptedRuntimeException(ex);
                    } catch (RuntimeException | ExecutionException | TimeoutException ex) {
                        logger.error("segment updating failed: " + segmentKey, ex);
                        result.segmentUploadFailed(segmentKey);
                    }
                });

        return result;
    }
}
