package ru.yandex.direct.jobs.segment.common.target;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.user.repository.UserRepository;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.jobs.segment.common.metrica.UploadSegmentsService;
import ru.yandex.direct.jobs.segment.common.target.name.SegmentNameHelper;

@Component
public class SegmentTargetUpdatingStrategyFactory {

    private final UploadSegmentsService uploadSegmentsService;
    private final UserRepository userRepository;
    private final SegmentNameHelper segmentNameHelper;
    private final ShardHelper shardHelper;

    @Autowired
    public SegmentTargetUpdatingStrategyFactory(UploadSegmentsService uploadSegmentsService,
                                                UserRepository userRepository,
                                                SegmentNameHelper segmentNameHelper,
                                                ShardHelper shardHelper) {
        this.uploadSegmentsService = uploadSegmentsService;
        this.userRepository = userRepository;
        this.segmentNameHelper = segmentNameHelper;
        this.shardHelper = shardHelper;
    }

    public SegmentTargetUpdatingStrategy createUpdatingStrategyForUpdateSegments() {
        return new SegmentTargetUpdatingStrategy(
                new UpdateYaAudienceSegmentUploadStrategy(uploadSegmentsService, shardHelper));
    }

    public SegmentTargetUpdatingStrategy createUpdatingStrategyForCreateSegments() {
        return new SegmentTargetUpdatingStrategy(
                new CreateYaAudienceSegmentUploadStrategy(userRepository,
                        segmentNameHelper, uploadSegmentsService, shardHelper));
    }
}
