package ru.yandex.direct.jobs.segment.common.target;

import java.math.BigInteger;
import java.util.Set;

import ru.yandex.direct.audience.client.model.SegmentContentType;
import ru.yandex.direct.core.entity.adgroup.model.UsersSegment;
import ru.yandex.direct.core.entity.metrika.model.Segment;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.jobs.segment.common.metrica.UploadSegmentsService;
import ru.yandex.direct.jobs.segment.common.result.SegmentUploadResult;

public class UpdateYaAudienceSegmentUploadStrategy implements YaAudienceSegmentUploadStrategy {

    private final UploadSegmentsService uploadSegmentsService;
    private final ShardHelper shardHelper;

    public UpdateYaAudienceSegmentUploadStrategy(UploadSegmentsService uploadSegmentsService,
                                                 ShardHelper shardHelper) {
        this.uploadSegmentsService = uploadSegmentsService;
        this.shardHelper = shardHelper;
    }

    @Override
    public SegmentUploadResult upload(UsersSegment segmentMeta, Set<BigInteger> uids, SegmentContentType contentType) {
        String segmentOwnerLogin = shardHelper.getLoginByUid(segmentMeta.getSegmentOwnerUid());
        Segment segment = uploadSegmentsService.modifySegmentSafe(segmentMeta.getExternalAudienceId(),
                segmentOwnerLogin, uids);
        return new SegmentUploadResult(segmentMeta.getSegmentOwnerUid(), segment.getId(), segment.getStatus());
    }
}
