package ru.yandex.direct.jobs.segment.jobs.cmpdefault;

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod;
import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.UsersSegment;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.jobs.base.logdatatransfer.ShardedLogDataTransferJob;
import ru.yandex.direct.jobs.segment.common.SegmentJugglerStatusCalculator;
import ru.yandex.direct.jobs.segment.common.SegmentMetricsProvider;
import ru.yandex.direct.jobs.segment.common.meta.SegmentMetaFetchingStrategyFactory;
import ru.yandex.direct.jobs.segment.common.meta.SegmentMetaUpdatingStrategyFactory;
import ru.yandex.direct.jobs.segment.common.result.SegmentUpdateResult;
import ru.yandex.direct.jobs.segment.common.target.SegmentTargetUpdatingStrategyFactory;
import ru.yandex.direct.jobs.segment.log.SegmentSourceData;
import ru.yandex.direct.jobs.segment.log.cpmdefault.CpmDefaultLogFetchingStrategyFactory;
import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification;
import ru.yandex.direct.juggler.check.model.NotificationRecipient;
import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.solomon.SolomonPushClient;

import static ru.yandex.direct.common.db.PpcPropertyNames.SEGMENT_JOBS_RUN_GREEDY_JOBS;
import static ru.yandex.direct.common.db.PpcPropertyNames.SEGMENT_JOBS_SEGMENTS_LIMIT;
import static ru.yandex.direct.jobs.segment.common.SegmentUtils.ITERATION_SEGMENTS_LIMIT;
import static ru.yandex.direct.jobs.segment.log.cpmdefault.CpmDefaultLogFetchingStrategyFactory.CPM_DEFAULT_CRITICAL_LOG_GAP_DAYS;

@JugglerCheck(ttl = @JugglerCheck.Duration(hours = 4),
        notifications = @OnChangeNotification(
                recipient = NotificationRecipient.LOGIN_KHUZINAZAT,
                method = NotificationMethod.TELEGRAM,
                status = {JugglerStatus.OK, JugglerStatus.CRIT}
        ),
        needCheck = ProductionOnly.class
)
@Hourglass(cronExpression = "0 15/30 * * * ?", needSchedule = ProductionOnly.class)
public class CpmVideoUpdateSegmentJob
        extends ShardedLogDataTransferJob<UsersSegment, SegmentSourceData, SegmentUpdateResult> {

    private static final String SOLOMON_LABEL = CpmVideoUpdateSegmentJob.class.getSimpleName();

    public CpmVideoUpdateSegmentJob(SegmentMetaFetchingStrategyFactory metaFetchingStrategyFactory,
                                    CpmDefaultLogFetchingStrategyFactory logFetchingStrategyFactory,
                                    SegmentTargetUpdatingStrategyFactory targetUpdatingStrategyFactory,
                                    SegmentMetaUpdatingStrategyFactory metaUpdatingStrategyFactory,
                                    PpcPropertiesSupport ppcPropertiesSupport,
                                    SolomonPushClient solomonPushClient) {
        super(metaFetchingStrategyFactory.createFetchingStrategyForUpdateSegments(AdGroupType.CPM_VIDEO),
                logFetchingStrategyFactory.createGreedyLogFetchingStrategy(),
                null,
                targetUpdatingStrategyFactory.createUpdatingStrategyForUpdateSegments(),
                metaUpdatingStrategyFactory.createMetaUpdatingStrategy(),
                new SegmentJugglerStatusCalculator(CPM_DEFAULT_CRITICAL_LOG_GAP_DAYS),
                new SegmentMetricsProvider(solomonPushClient, SOLOMON_LABEL),
                ppcPropertiesSupport.get(SEGMENT_JOBS_SEGMENTS_LIMIT),
                ITERATION_SEGMENTS_LIMIT,
                ppcPropertiesSupport.get(SEGMENT_JOBS_RUN_GREEDY_JOBS));
    }
}
