package ru.yandex.direct.jobs.segment.jobs.common

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcPropertyNames
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType
import ru.yandex.direct.core.entity.adgroup.model.UsersSegment
import ru.yandex.direct.env.ProductionOnly
import ru.yandex.direct.jobs.base.logdatatransfer.ShardedLogDataTransferJob
import ru.yandex.direct.jobs.segment.common.SegmentJugglerStatusCalculator
import ru.yandex.direct.jobs.segment.common.SegmentMetricsProvider
import ru.yandex.direct.jobs.segment.common.SegmentUtils
import ru.yandex.direct.jobs.segment.log.common.CommonLogFetchingStrategyFactory
import ru.yandex.direct.jobs.segment.log.SegmentSourceData
import ru.yandex.direct.jobs.segment.common.meta.SegmentMetaFetchingStrategyFactory
import ru.yandex.direct.jobs.segment.common.meta.SegmentMetaUpdatingStrategyFactory
import ru.yandex.direct.jobs.segment.common.preprocessor.SegmentSourceDataPreprocessorFactory
import ru.yandex.direct.jobs.segment.common.result.SegmentUpdateResult
import ru.yandex.direct.jobs.segment.common.target.SegmentTargetUpdatingStrategyFactory
import ru.yandex.direct.juggler.JugglerStatus
import ru.yandex.direct.juggler.check.annotation.JugglerCheck
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification
import ru.yandex.direct.juggler.check.model.NotificationRecipient
import ru.yandex.direct.scheduler.Hourglass
import ru.yandex.direct.solomon.SolomonPushClient

/**
 * По видевшим текстовые баннеры пользователям создает сегменты в Аудиториях
 */
@JugglerCheck(
    ttl = JugglerCheck.Duration(hours = 4),
    notifications = [OnChangeNotification(
        recipient = [NotificationRecipient.LOGIN_KHUZINAZAT],
        method = [NotificationMethod.TELEGRAM],
        status = [JugglerStatus.OK, JugglerStatus.CRIT]
    )],
    needCheck = ProductionOnly::class
)
@Hourglass(cronExpression = "0 15/30 * * * ?", needSchedule = ProductionOnly::class)
class TextBannerCreateSegmentJob(
    metaFetchingStrategyFactory: SegmentMetaFetchingStrategyFactory,
    logFetchingStrategyFactory: CommonLogFetchingStrategyFactory,
    preprocessorFactory: SegmentSourceDataPreprocessorFactory,
    targetUpdatingStrategyFactory: SegmentTargetUpdatingStrategyFactory,
    metaUpdatingStrategyFactory: SegmentMetaUpdatingStrategyFactory,
    ppcPropertiesSupport: PpcPropertiesSupport,
    solomonPushClient: SolomonPushClient,
): ShardedLogDataTransferJob<UsersSegment, SegmentSourceData, SegmentUpdateResult>(
    metaFetchingStrategyFactory.createFetchingStrategyForCreateSegments(AdGroupType.BASE),
    logFetchingStrategyFactory.createGreedyLogFetchingStrategy(),
    null,
    targetUpdatingStrategyFactory.createUpdatingStrategyForCreateSegments(),
    metaUpdatingStrategyFactory.createMetaUpdatingStrategy(),
    SegmentJugglerStatusCalculator(CommonLogFetchingStrategyFactory.DEFAULT_CRITICAL_LOG_GAP_DAYS),
    SegmentMetricsProvider(solomonPushClient, TextBannerCreateSegmentJob::class.java.simpleName),
    ppcPropertiesSupport.get(PpcPropertyNames.SEGMENT_JOBS_SEGMENTS_LIMIT),
    SegmentUtils.ITERATION_SEGMENTS_LIMIT,
    ppcPropertiesSupport.get(PpcPropertyNames.SEGMENT_JOBS_RUN_TEXT_GREEDY_JOBS)
)
