package ru.yandex.direct.jobs.segment.jobs.intermediate

import ru.yandex.direct.common.db.PpcProperty
import ru.yandex.direct.jobs.segment.common.SegmentUtils
import ru.yandex.direct.jobs.segment.log.IntermediateSegmentYtRepository
import ru.yandex.direct.scheduler.support.DirectJob
import ru.yandex.direct.ytwrapper.client.YtProvider
import java.time.LocalDate
import java.util.function.Function

abstract class SegmentIntermediateTableCreateJob(
    private val ytProvider: YtProvider,
    private val intermediateSegmentYtRepository: IntermediateSegmentYtRepository,
    private val startLogDateProperty: PpcProperty<LocalDate>,
    private val ignoreMissedDaysProperty: PpcProperty<Boolean>,
    private val logPathProvider: Function<LocalDate, String>,
    private val yqlPath: String,
): DirectJob() {
    override fun execute() {
        val forceDestTableStartDate = startLogDateProperty.get()
        val intermediateTablesCreator = SegmentsIntermediateTablesCreator(
            ytProvider,
            SegmentUtils.SEGMENTS_CLUSTER,
            forceDestTableStartDate,
            logPathProvider,
            intermediateSegmentYtRepository.intermediateTablePathProvider(),
            yqlPath,
            ignoreMissedDaysProperty.getOrDefault(false)
        )
        intermediateTablesCreator.execute()
        if (forceDestTableStartDate != null) {
            startLogDateProperty.remove()
        }
    }
}
