package ru.yandex.direct.jobs.segment.jobs.intermediate

import org.slf4j.LoggerFactory
import ru.yandex.direct.jobs.segment.common.SegmentUtils
import ru.yandex.direct.jobs.segment.log.IntermediateSegmentYtRepository
import ru.yandex.direct.scheduler.support.DirectJob
import ru.yandex.direct.ytwrapper.client.YtProvider
import ru.yandex.direct.ytwrapper.model.YqlQuery
import ru.yandex.direct.ytwrapper.model.YtTable
import java.time.LocalDate

abstract class SegmentIntermediateTableRemoveJob(
    private val ytProvider: YtProvider,
    private val intermediateSegmentYtRepository: IntermediateSegmentYtRepository,
): DirectJob() {
    companion object {
        private val logger = LoggerFactory.getLogger(SegmentIntermediateTableRemoveJob::class.java)
        private const val YQL = "drop table `?`"
    }

    override fun execute() {
        val ytOperator = ytProvider.getOperator(SegmentUtils.SEGMENTS_CLUSTER)
        var curLogDateToDelete = intermediateSegmentYtRepository.oldestLogDate.minusDays(1)
        while (ytOperator.exists(getTable(curLogDateToDelete))) {
            val tablePath = getPath(curLogDateToDelete)
            logger.info("starting YQL for removing intermediate table `{}`...", tablePath)
            val resultSetFuture = ytOperator.yqlQueryBegin(YqlQuery(YQL, tablePath))
            logger.info("started YQL (operationId = {}) for removing intermediate table `{}`",
                resultSetFuture.operationId, tablePath)
            curLogDateToDelete = curLogDateToDelete.minusDays(1)
        }
    }

    private fun getTable(localDate: LocalDate) = YtTable(getPath(localDate))

    private fun getPath(localDate: LocalDate) =
        intermediateSegmentYtRepository.intermediateTablePathProvider().apply(localDate)
}
