package ru.yandex.direct.jobs.segment.jobs.intermediate.common

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcPropertyNames.SEGMENT_JOBS_IGNORE_MISSED_DAYS
import ru.yandex.direct.common.db.PpcPropertyNames.SEGMENT_JOBS_INTERMEDIATE_START_LOG_DATE
import ru.yandex.direct.common.db.PpcPropertyNames.SEGMENT_JOBS_RUN_COMMON_INTERMEDIATE_JOBS
import ru.yandex.direct.env.ProductionOnly
import ru.yandex.direct.jobs.segment.common.SegmentUtils.commonLogPathProvider
import ru.yandex.direct.jobs.segment.log.common.CommonIntermediateSegmentYtRepository
import ru.yandex.direct.jobs.segment.jobs.intermediate.SegmentIntermediateTableCreateJob
import ru.yandex.direct.juggler.JugglerStatus
import ru.yandex.direct.juggler.check.annotation.JugglerCheck
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification
import ru.yandex.direct.juggler.check.model.NotificationRecipient
import ru.yandex.direct.scheduler.Hourglass
import ru.yandex.direct.ytwrapper.client.YtProvider

/**
 * Джоба создаёт сортированную табличку только с необходимыми для сбора
 * сегментов пользователей (по cryptaid) на основе подневных логов движка
 * https://yt.yandex-team.ru/hahn/navigation?path=//cooked_logs/bs-chevent-cooked-log/1d
 */
@JugglerCheck(
    ttl = JugglerCheck.Duration(hours = 4),
    notifications = [OnChangeNotification(
        recipient = [NotificationRecipient.LOGIN_KHUZINAZAT],
        method = [NotificationMethod.TELEGRAM],
        status = [JugglerStatus.OK, JugglerStatus.CRIT]
    )],
    needCheck = ProductionOnly::class
)
@Hourglass(cronExpression = "0 0 0/2 * * ?", needSchedule = ProductionOnly::class)
class CommonSegmentIntermediateTableCreateJob(
    ytProvider: YtProvider,
    commonIntermediateSegmentYtRepository: CommonIntermediateSegmentYtRepository,
    private val ppcPropertiesSupport: PpcPropertiesSupport,
): SegmentIntermediateTableCreateJob(
    ytProvider,
    commonIntermediateSegmentYtRepository,
    ppcPropertiesSupport[SEGMENT_JOBS_INTERMEDIATE_START_LOG_DATE],
    ppcPropertiesSupport[SEGMENT_JOBS_IGNORE_MISSED_DAYS],
    commonLogPathProvider(),
    "segment/importBsCheventSegmentUsers.sql"
) {
    override fun execute() {
        val isEnabled = ppcPropertiesSupport[SEGMENT_JOBS_RUN_COMMON_INTERMEDIATE_JOBS].getOrDefault(false)
        if (!isEnabled) {
            return
        }
        super.execute()
    }
}
