package ru.yandex.direct.jobs.segment.jobs.intermediate.common

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcPropertyNames.SEGMENT_JOBS_RUN_COMMON_INTERMEDIATE_JOBS
import ru.yandex.direct.env.ProductionOnly
import ru.yandex.direct.jobs.segment.log.common.CommonIntermediateSegmentYtRepository
import ru.yandex.direct.jobs.segment.jobs.intermediate.SegmentIntermediateTableRemoveJob
import ru.yandex.direct.juggler.JugglerStatus
import ru.yandex.direct.juggler.check.annotation.JugglerCheck
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification
import ru.yandex.direct.juggler.check.model.NotificationRecipient
import ru.yandex.direct.scheduler.Hourglass
import ru.yandex.direct.ytwrapper.client.YtProvider

/**
 * Джоба удаляет устаревшие таблички, которые создаются джобой [CommonSegmentIntermediateTableCreateJob].
 */
@JugglerCheck(
    ttl = JugglerCheck.Duration(hours = 30),
    notifications = [OnChangeNotification(
        recipient = [NotificationRecipient.LOGIN_KHUZINAZAT],
        method = [NotificationMethod.TELEGRAM],
        status = [JugglerStatus.OK, JugglerStatus.CRIT]
    )],
    needCheck = ProductionOnly::class
)
@Hourglass(cronExpression = "0 0 3 * * ?", needSchedule = ProductionOnly::class)
class CommonSegmentIntermediateTableRemoveJob(
    ytProvider: YtProvider,
    intermediateSegmentYtRepository: CommonIntermediateSegmentYtRepository,
    private val ppcPropertiesSupport: PpcPropertiesSupport,
) : SegmentIntermediateTableRemoveJob(
    ytProvider,
    intermediateSegmentYtRepository
) {
    override fun execute() {
        val isEnabled = ppcPropertiesSupport[SEGMENT_JOBS_RUN_COMMON_INTERMEDIATE_JOBS].getOrDefault(false)
        if (!isEnabled) {
            return
        }
        super.execute()
    }
}
