package ru.yandex.direct.jobs.segment.jobs.intermediate.cpmdefault;

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod;
import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.jobs.segment.jobs.intermediate.SegmentIntermediateTableCreateJob;
import ru.yandex.direct.jobs.segment.log.cpmdefault.CpmDefaultIntermediateSegmentYtRepository;
import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification;
import ru.yandex.direct.juggler.check.model.NotificationRecipient;
import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.ytwrapper.client.YtProvider;

import static ru.yandex.direct.common.db.PpcPropertyNames.SEGMENT_JOBS_CPM_INTERMEDIATE_START_LOG_DATE;
import static ru.yandex.direct.common.db.PpcPropertyNames.SEGMENT_JOBS_IGNORE_MISSED_DAYS;
import static ru.yandex.direct.jobs.segment.log.cpmdefault.CpmDefaultSegmentUtils.cpmDefaultLogPathProvider;

/**
 * Джоба создаёт сортированную табличку только с необходимыми для сбора
 * cpm-сегментов пользователей (по uniqid) на основе подневных логов движка
 * https://yt.yandex-team.ru/hahn/navigation?path=//logs/bs-chtracking-log/1d.
 */
@JugglerCheck(ttl = @JugglerCheck.Duration(hours = 4),
        notifications = @OnChangeNotification(
                recipient = NotificationRecipient.LOGIN_KHUZINAZAT,
                method = NotificationMethod.TELEGRAM,
                status = {JugglerStatus.OK, JugglerStatus.CRIT}
        ),
        needCheck = ProductionOnly.class
)
@Hourglass(cronExpression = "0 0 0/2 * * ?", needSchedule = ProductionOnly.class)
public class CpmDefaultSegmentIntermediateTableCreateJob extends SegmentIntermediateTableCreateJob {

    public CpmDefaultSegmentIntermediateTableCreateJob(
            YtProvider ytProvider,
            PpcPropertiesSupport ppcPropertiesSupport,
            CpmDefaultIntermediateSegmentYtRepository intermediateSegmentYtRepository) {
        super(
                ytProvider,
                intermediateSegmentYtRepository,
                ppcPropertiesSupport.get(SEGMENT_JOBS_CPM_INTERMEDIATE_START_LOG_DATE),
                ppcPropertiesSupport.get(SEGMENT_JOBS_IGNORE_MISSED_DAYS),
                cpmDefaultLogPathProvider(),
                "segment/importBsChtrackingSegmentUsers.sql"
        );
    }
}
