package ru.yandex.direct.jobs.segment.jobs.intermediate.cpmdefault;

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.jobs.segment.jobs.intermediate.SegmentIntermediateTableRemoveJob;
import ru.yandex.direct.jobs.segment.log.cpmdefault.CpmDefaultIntermediateSegmentYtRepository;
import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification;
import ru.yandex.direct.juggler.check.model.NotificationRecipient;
import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.ytwrapper.client.YtProvider;

/**
 * Джоба удаляет устаревшие таблички, которые создаются джобой {@link CpmDefaultSegmentIntermediateTableCreateJob}.
 */
@JugglerCheck(ttl = @JugglerCheck.Duration(hours = 30),
        notifications = @OnChangeNotification(
                recipient = NotificationRecipient.LOGIN_KHUZINAZAT,
                method = NotificationMethod.TELEGRAM,
                status = {JugglerStatus.OK, JugglerStatus.CRIT}
        ),
        needCheck = ProductionOnly.class
)
@Hourglass(cronExpression = "0 0 3 * * ?", needSchedule = ProductionOnly.class)
public class CpmDefaultSegmentIntermediateTableRemoveJob extends SegmentIntermediateTableRemoveJob {
    public CpmDefaultSegmentIntermediateTableRemoveJob(
            YtProvider ytProvider,
            CpmDefaultIntermediateSegmentYtRepository intermediateSegmentYtRepository) {
        super(ytProvider, intermediateSegmentYtRepository);
    }
}
