package ru.yandex.direct.jobs.segment.jobs.status;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.model.YqlQuery;
import ru.yandex.direct.ytwrapper.model.YtCluster;
import ru.yandex.yql.response.YqlResultSet;

import static java.util.Collections.emptyList;

/**
 * Репозиторий для работы с таблицей
 * https://yt.yandex-team.ru/hahn/navigation?path=//home/audience/production/export/segments_simple
 */
@Repository
public class AudienceSegmentSimpleYtRepository {

    private static final String SQL_TEMPLATE = "select id, status, deleted\n" +
            "from `//home/audience/production/export/segments_simple`\n" +
            "where id in (%s)";

    private final YtProvider ytProvider;

    @Autowired
    public AudienceSegmentSimpleYtRepository(YtProvider ytProvider) {
        this.ytProvider = ytProvider;
    }

    public List<SegmentWithStatus> getStatuses(List<Long> segmentIds) {
        if (segmentIds.isEmpty()) {
            return emptyList();
        }
        YqlQuery query = new YqlQuery(String.format(SQL_TEMPLATE, StringUtils.join(segmentIds, ", ")));

        List<SegmentWithStatus> result = new ArrayList<>();
        ytProvider.getOperator(YtCluster.HAHN).yqlQuery(query, resultSet -> map(resultSet, result));
        return result;
    }

    private Object map(ResultSet resultSet, List<SegmentWithStatus> result) throws SQLException {
        YqlResultSet yqlResultSet = (YqlResultSet) resultSet;
        Long id = yqlResultSet.getUnsignedLong(1);
        SegmentYtExternalStatus status = SegmentYtExternalStatus.fromSource(yqlResultSet.getString("status"));
        boolean deleted = yqlResultSet.getUnsignedLong(3) == 1;
        result.add(new SegmentWithStatus(id, status, deleted));
        return null;
    }
}
