package ru.yandex.direct.jobs.segment.jobs.status;

public enum SegmentYtExternalStatus {
    FEW_DATA,
    IS_PROCESSED,
    CONFIRMED,
    PROCESS_UPDATED,
    PROCESSED_FULLY,
    PROCESSING_FAILED,
    UPDATED,
    UPLOADED,
    UNKNOWN;

    public static SegmentYtExternalStatus fromSource(String sourceStatus) {
        if (sourceStatus == null) {
            return SegmentYtExternalStatus.UNKNOWN;
        }
        try {
            return SegmentYtExternalStatus.valueOf(sourceStatus.toUpperCase());
        } catch (Exception e) {
            return SegmentYtExternalStatus.UNKNOWN;
        }
    }
}
