package ru.yandex.direct.jobs.segment.log;

import java.time.LocalDate;
import java.util.Objects;

import ru.yandex.direct.ytwrapper.model.YtTable;

import static com.google.common.base.Preconditions.checkNotNull;

public class DayLog {

    private final LocalDate logDate;
    private final YtTable logTable;

    public DayLog(LocalDate logDate, YtTable logTable) {
        checkNotNull(logDate, "logDate");
        checkNotNull(logTable, "logTable");
        this.logDate = logDate;
        this.logTable = logTable;
    }

    public LocalDate getLogDate() {
        return logDate;
    }

    public YtTable getLogTable() {
        return logTable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DayLog dayLog = (DayLog) o;
        return logDate.equals(dayLog.logDate) &&
                logTable.equals(dayLog.logTable);
    }

    @Override
    public int hashCode() {
        return Objects.hash(logDate, logTable);
    }
}
