package ru.yandex.direct.jobs.segment.log;

import java.math.BigInteger;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

import ru.yandex.direct.audience.client.model.SegmentContentType;
import ru.yandex.direct.jobs.segment.common.meta.SegmentKey;

public interface IntermediateSegmentYtRepository {

    Function<LocalDate, String> intermediateTablePathProvider();

    LocalDate getMostFreshLogDate();

    LocalDate getOldestLogDate();

    Map<SegmentKey, Long> getCount(Collection<SegmentKey> segmentKeys, LocalDate from, LocalDate to);

    Map<SegmentKey, Set<BigInteger>> getData(Collection<SegmentKey> segmentKeys, LocalDate from, LocalDate to);

    SegmentContentType getContentType();
}
