package ru.yandex.direct.jobs.segment.log.common

import org.springframework.stereotype.Component
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcProperty
import ru.yandex.direct.common.db.PpcPropertyNames
import ru.yandex.direct.jobs.segment.log.greedy.GreedySegmentLogFetchingStrategy
import java.time.Duration

@Component
class CommonLogFetchingStrategyFactory(
    private val intermediateSegmentYtRepository: CommonIntermediateSegmentYtRepository,
    ppcPropertiesSupport: PpcPropertiesSupport
) {
    private val packLimitProperty: PpcProperty<Long>
    fun createGreedyLogFetchingStrategy() =
        GreedySegmentLogFetchingStrategy(intermediateSegmentYtRepository, packLimitProperty, DEFAULT_LIMIT)

    companion object {
        private const val DEFAULT_LIMIT = 10000000L
        const val DEFAULT_CRITICAL_LOG_GAP_DAYS = 3
    }

    init {
        packLimitProperty = ppcPropertiesSupport.get(PpcPropertyNames.SEGMENT_JOBS_DATA_LIMIT, Duration.ofMinutes(1))
    }
}
