package ru.yandex.direct.jobs.segment.log.cpmdefault;

import java.time.Duration;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.common.db.PpcProperty;
import ru.yandex.direct.core.entity.adgroup.model.UsersSegment;
import ru.yandex.direct.jobs.base.logdatatransfer.LogFetchingStrategy;
import ru.yandex.direct.jobs.segment.log.SegmentSourceData;
import ru.yandex.direct.jobs.segment.log.greedy.GreedySegmentLogFetchingStrategy;

import static ru.yandex.direct.common.db.PpcPropertyNames.SEGMENT_JOBS_DATA_LIMIT;

@Component
public class CpmDefaultLogFetchingStrategyFactory {

    private static final long DEFAULT_LIMIT = 10_000_000;

    public static final int CPM_DEFAULT_CRITICAL_LOG_GAP_DAYS = 3;

    private final CpmDefaultIntermediateSegmentYtRepository intermediateSegmentYtRepository;
    private final PpcProperty<Long> packLimitProperty;

    @Autowired
    public CpmDefaultLogFetchingStrategyFactory(
            CpmDefaultIntermediateSegmentYtRepository intermediateSegmentYtRepository,
            PpcPropertiesSupport ppcPropertiesSupport) {
        this.intermediateSegmentYtRepository = intermediateSegmentYtRepository;
        this.packLimitProperty =
                ppcPropertiesSupport.get(SEGMENT_JOBS_DATA_LIMIT, Duration.ofMinutes(1));
    }

    public LogFetchingStrategy<UsersSegment, SegmentSourceData> createGreedyLogFetchingStrategy() {
        return new GreedySegmentLogFetchingStrategy(intermediateSegmentYtRepository,
                packLimitProperty, DEFAULT_LIMIT);
    }
}
