package ru.yandex.direct.jobs.shoprating;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class ShopRating {
    private String domain;
    private Long rating;

    @JsonCreator
    public ShopRating(@JsonProperty(value = "domain", required = true) String domain,
                      @JsonProperty(value = "rating", required = true) Long rating) {
        this.domain = Objects.requireNonNull(domain);
        this.rating = Objects.requireNonNull(rating);
    }

    public String getDomain() {
        return domain;
    }

    public Long getRating() {
        return rating;
    }
}
