package ru.yandex.direct.jobs.sitelinks

import ru.yandex.direct.config.DirectConfig
import ru.yandex.direct.ytwrapper.YtPathUtil
import ru.yandex.direct.ytwrapper.client.YtProvider
import ru.yandex.direct.ytwrapper.model.YtCluster
import ru.yandex.direct.ytwrapper.model.YtOperator
import ru.yandex.inside.yt.kosher.cypress.YPath
import java.text.SimpleDateFormat
import java.time.Duration
import java.time.Instant
import java.util.Date

object ImportSitelinksUtils {
    const val tableNamePrefix = "import_from_bno"

    fun getLinkTargetPath(ytOperator: YtOperator, linkPath: String): YPath {
        val targetPathNode = YPath.simple("$linkPath&/@target_path")
        return YPath.simple(ytOperator.yt.cypress().get(targetPathNode).stringValue())
    }

    fun getWorkDirectory(ytProvider: YtProvider, cluster: YtCluster, directory: String): String {
        return YtPathUtil.generatePath(ytProvider.getClusterConfig(cluster).home, directory)
    }

    fun getTableName(): String {
        val date = SimpleDateFormat("yyyyMMdd_HHmmss").format(Date())
        return "${tableNamePrefix}_$date"
    }

    fun getCreatedAt(ytProvider: YtProvider, cluster: YtCluster, path: YPath): Instant? {
        val cypress = ytProvider.getOperator(cluster).yt.cypress()
        // В том числе проверяет, что симлинк ссылается на таблицу
        return if (cypress.exists(path)) {
            val node = cypress.get(path.attribute("creation_time"))
            Instant.parse(node.stringValue())
        } else {
            null
        }
    }

    fun getCurrentPath(workDirectory: String): String {
        return "$workDirectory/current"
    }
}

class ImportSitelinksConfig(directConfig: DirectConfig) {
    private val config: DirectConfig = directConfig.getBranch("sitelinks_import")

    val importTablePath: String = config.getString("import_table_path")

    val importClusters: List<YtCluster> = config.getStringList("import_clusters")
        .map { YtCluster.parse(it) }

    val outputClusters: List<YtCluster> = config.getStringList("output_clusters")
        .map { YtCluster.parse(it) }

    val directory: String = config.getString("output_directory")

    val tablesToKeep: Int = config.getInt("tables_to_keep")

    val freshDuration: Duration = config.getDuration("fresh_duration")
}
