package ru.yandex.direct.jobs.slowlogs.readers;

import java.time.Instant;

import javax.annotation.Nullable;

public class SlowLogRecordId implements Comparable<SlowLogRecordId> {
    public static final SlowLogRecordId MIN = new SlowLogRecordId(Instant.MIN);
    public static final SlowLogRecordId MAX = new SlowLogRecordId(Instant.MAX, Integer.MAX_VALUE);

    private final Instant timestamp;
    private final int positionInTimestamp;

    public SlowLogRecordId(Instant timestamp, int positionInTimestamp) {
        this.timestamp = timestamp;
        this.positionInTimestamp = positionInTimestamp;
    }

    public SlowLogRecordId(Instant timestamp) {
        this(timestamp, -1);
    }

    public Instant getTimestamp() {
        return timestamp;
    }

    public int getPositionInTimestamp() {
        return positionInTimestamp;
    }

    @Override
    public int compareTo(@Nullable SlowLogRecordId another) {
        if (another == null)
            return 1;
        int compareTimestamps = this.timestamp.compareTo(another.timestamp);
        if (compareTimestamps != 0)
            return compareTimestamps;
        else
            return this.positionInTimestamp - another.positionInTimestamp;
    }

    @Override
    public String toString() {
        return "SlowLogRecordId{" +
                "timestamp=" + timestamp +
                ", positionInTimestamp=" + positionInTimestamp +
                '}';
    }
}
