package ru.yandex.direct.jobs.slowlogs.transport;

import java.time.Instant;

public class MySqlSlowQueryLogRecord {
    private final String clusterId;
    private final String clusterName;
    private final int clusterVersion;
    private final long recordIdTimestamp;
    private final int recordIdPositionInTimestamp;
    private final String queryNormalForm;
    private final String queryService;
    private final String queryMethod;
    private final long queryRequestId;
    private final Instant timestamp;
    private final String queryText;
    private final String userName;
    private final String userSecondName;
    private final String userHost;
    private final String userIp;
    private final long connectionId;
    private final String schema;
    private final int lastErrorNumber;
    private final int killedCode;
    private final double queryTimeInSeconds;
    private final double lockTimeInSeconds;
    private final long rowsSentCount;
    private final long rowsExaminedCount;
    private final long rowsAffectedCount;
    private final long bytesSentCount;
    private final int tempTablesCount;
    private final int tempTablesOnDiskCount;
    private final long tempTablesSizesInBytes;
    private final long transactionId;
    private final boolean hasQcHit;
    private final boolean hasFullScan;
    private final boolean hasFullJoin;
    private final boolean hasTempTables;
    private final boolean hasTempTablesOnDisk;
    private final boolean hasFileSort;
    private final boolean hasFileSortOnDisk;
    private final int mergePassesCount;
    private final int innoDbIoReadOperationsCount;
    private final long innoDbIoReadBytesCount;
    private final double innoDbReadWaitInSeconds;
    private final double innoDbRecordsLockWaitInSeconds;
    private final double innoQbQueueWaitInSeconds;
    private final int innoDbPagesCountDistinct;
    private final String rawRecordText;

    public MySqlSlowQueryLogRecord(
            String clusterId,
            String clusterName,
            int clusterVersion,
            long recordIdTimestamp,
            int recordIdPositionInTimestamp,
            String queryNormalForm,
            String queryService,
            String queryMethod,
            long queryRequestId,
            Instant timestamp,
            String queryText,
            String userName,
            String userSecondName,
            String userHost,
            String userIp,
            long connectionId,
            String schema,
            int lastErrorNumber,
            int killedCode,
            double queryTimeInSeconds,
            double lockTimeInSeconds,
            long rowsSentCount,
            long rowsExaminedCount,
            long rowsAffectedCount,
            long bytesSentCount,
            int tempTablesCount,
            int tempTablesOnDiskCount,
            long tempTablesSizesInBytes,
            long transactionId,
            boolean hasQcHit,
            boolean hasFullScan,
            boolean hasFullJoin,
            boolean hasTempTables,
            boolean hasTempTablesOnDisk,
            boolean hasFileSort,
            boolean hasFileSortOnDisk,
            int mergePassesCount,
            int innoDbIoReadOperationsCount,
            long innoDbIoReadBytesCount,
            double innoDbReadWaitInSeconds,
            double innoDbRecordsLockWaitInSeconds,
            double innoQbQueueWaitInSeconds,
            int innoDbPagesCountDistinct,
            String rawRecordText) {
        this.clusterId = clusterId;
        this.clusterName = clusterName;
        this.clusterVersion = clusterVersion;
        this.recordIdTimestamp = recordIdTimestamp;
        this.recordIdPositionInTimestamp = recordIdPositionInTimestamp;
        this.queryNormalForm = queryNormalForm;
        this.queryService = queryService;
        this.queryMethod = queryMethod;
        this.queryRequestId = queryRequestId;
        this.timestamp = timestamp;
        this.queryText = queryText;
        this.userName = userName;
        this.userSecondName = userSecondName;
        this.userHost = userHost;
        this.userIp = userIp;
        this.connectionId = connectionId;
        this.schema = schema;
        this.lastErrorNumber = lastErrorNumber;
        this.killedCode = killedCode;
        this.queryTimeInSeconds = queryTimeInSeconds;
        this.lockTimeInSeconds = lockTimeInSeconds;
        this.rowsSentCount = rowsSentCount;
        this.rowsExaminedCount = rowsExaminedCount;
        this.rowsAffectedCount = rowsAffectedCount;
        this.bytesSentCount = bytesSentCount;
        this.tempTablesCount = tempTablesCount;
        this.tempTablesOnDiskCount = tempTablesOnDiskCount;
        this.tempTablesSizesInBytes = tempTablesSizesInBytes;
        this.transactionId = transactionId;
        this.hasQcHit = hasQcHit;
        this.hasFullScan = hasFullScan;
        this.hasFullJoin = hasFullJoin;
        this.hasTempTables = hasTempTables;
        this.hasTempTablesOnDisk = hasTempTablesOnDisk;
        this.hasFileSort = hasFileSort;
        this.hasFileSortOnDisk = hasFileSortOnDisk;
        this.mergePassesCount = mergePassesCount;
        this.innoDbIoReadOperationsCount = innoDbIoReadOperationsCount;
        this.innoDbIoReadBytesCount = innoDbIoReadBytesCount;
        this.innoDbReadWaitInSeconds = innoDbReadWaitInSeconds;
        this.innoDbRecordsLockWaitInSeconds = innoDbRecordsLockWaitInSeconds;
        this.innoQbQueueWaitInSeconds = innoQbQueueWaitInSeconds;
        this.innoDbPagesCountDistinct = innoDbPagesCountDistinct;
        this.rawRecordText = rawRecordText;
    }

    public String getClusterId() {
        return clusterId;
    }

    public String getClusterName() {
        return clusterName;
    }

    public int getClusterVersion() {
        return clusterVersion;
    }

    public long getRecordIdTimestamp() {
        return recordIdTimestamp;
    }

    public int getRecordIdPositionInTimestamp() {
        return recordIdPositionInTimestamp;
    }

    public String getQueryNormalForm() {
        return queryNormalForm;
    }

    public String getQueryService() {
        return queryService;
    }

    public String getQueryMethod() {
        return queryMethod;
    }

    public long getQueryRequestId() {
        return queryRequestId;
    }

    public Instant getTimestamp() {
        return timestamp;
    }

    public String getQueryText() {
        return queryText;
    }

    public String getUserName() {
        return userName;
    }

    public String getUserSecondName() {
        return userSecondName;
    }

    public String getUserHost() {
        return userHost;
    }

    public String getUserIp() {
        return userIp;
    }

    public long getConnectionId() {
        return connectionId;
    }

    public String getSchema() {
        return schema;
    }

    public int getLastErrorNumber() {
        return lastErrorNumber;
    }

    public int getKilledCode() {
        return killedCode;
    }

    public double getQueryTimeInSeconds() {
        return queryTimeInSeconds;
    }

    public double getLockTimeInSeconds() {
        return lockTimeInSeconds;
    }

    public long getRowsSentCount() {
        return rowsSentCount;
    }

    public long getRowsExaminedCount() {
        return rowsExaminedCount;
    }

    public long getRowsAffectedCount() {
        return rowsAffectedCount;
    }

    public long getBytesSentCount() {
        return bytesSentCount;
    }

    public int getTempTablesCount() {
        return tempTablesCount;
    }

    public int getTempTablesOnDiskCount() {
        return tempTablesOnDiskCount;
    }

    public long getTempTablesSizesInBytes() {
        return tempTablesSizesInBytes;
    }

    public long getTransactionId() {
        return transactionId;
    }

    public boolean isHasQcHit() {
        return hasQcHit;
    }

    public boolean isHasFullScan() {
        return hasFullScan;
    }

    public boolean isHasFullJoin() {
        return hasFullJoin;
    }

    public boolean isHasTempTables() {
        return hasTempTables;
    }

    public boolean isHasTempTablesOnDisk() {
        return hasTempTablesOnDisk;
    }

    public boolean isHasFileSort() {
        return hasFileSort;
    }

    public boolean isHasFileSortOnDisk() {
        return hasFileSortOnDisk;
    }

    public int getMergePassesCount() {
        return mergePassesCount;
    }

    public int getInnoDbIoReadOperationsCount() {
        return innoDbIoReadOperationsCount;
    }

    public long getInnoDbIoReadBytesCount() {
        return innoDbIoReadBytesCount;
    }

    public double getInnoDbReadWaitInSeconds() {
        return innoDbReadWaitInSeconds;
    }

    public double getInnoDbRecordsLockWaitInSeconds() {
        return innoDbRecordsLockWaitInSeconds;
    }

    public double getInnoQbQueueWaitInSeconds() {
        return innoQbQueueWaitInSeconds;
    }

    public int getInnoDbPagesCountDistinct() {
        return innoDbPagesCountDistinct;
    }

    public String getRawRecordText() {
        return rawRecordText;
    }
}
