package ru.yandex.direct.jobs.statistics;

import java.time.LocalDateTime;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod;
import ru.yandex.direct.core.entity.mdsfile.model.MdsStorageType;
import ru.yandex.direct.core.entity.mdsfile.service.MdsFileService;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.env.TypicalEnvironment;
import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification;
import ru.yandex.direct.juggler.check.model.CheckTag;
import ru.yandex.direct.juggler.check.model.NotificationRecipient;
import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.scheduler.support.DirectShardedJob;

/**
 * Джоба удаления старых выгрузок статистики по Brand Safety
 */
@JugglerCheck(ttl = @JugglerCheck.Duration(days = 2),
        tags = {CheckTag.DIRECT_PRODUCT_TEAM},
        notifications = {
                @OnChangeNotification(recipient = NotificationRecipient.LOGIN_IVATKOEGOR,
                        status = {JugglerStatus.OK, JugglerStatus.CRIT},
                        method = NotificationMethod.TELEGRAM),
        },
        needCheck = ProductionOnly.class
)
@Hourglass(cronExpression = "0 30 2 * * ?", needSchedule = TypicalEnvironment.class)
@ParametersAreNonnullByDefault
public class BrandSafetyStatReportMdsCleanerJob extends DirectShardedJob {
    private static final int REPORT_LIFETIME_DAYS = 3;

    private final MdsFileService mdsFileService;

    public BrandSafetyStatReportMdsCleanerJob(MdsFileService mdsFileService) {
        this.mdsFileService = mdsFileService;
    }

    @Override
    public void execute() {
        var thresholdTime = LocalDateTime.now().minusDays(REPORT_LIFETIME_DAYS);
        mdsFileService.deleteOldMdsFiles(getShard(), thresholdTime, MdsStorageType.BRAND_SAFETY_STATS_REPORT);
    }
}
