package ru.yandex.direct.jobs.statistics.activeorders;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import ru.yandex.direct.scheduler.support.ParametersSource;

@Component
public class ActiveOrdersImportParametersSource implements ParametersSource<Integer> {
    private final List<Integer> workers;

    @Autowired
    public ActiveOrdersImportParametersSource(@Value("${statistics.activeorders.workers_count}") int workersCount) {
        this.workers = IntStream.range(0, workersCount).boxed().collect(Collectors.toList());
    }

    @Override
    public List<Integer> getAllParamValues() {
        return workers;
    }

    @Override
    public String convertParamToString(Integer paramValue) {
        return paramValue.toString();
    }

    @Override
    public Integer convertStringToParam(String string) {
        return Integer.parseInt(string);
    }
}
