package ru.yandex.direct.jobs.statistics.activeorders;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.Rate;

import static ru.yandex.direct.solomon.SolomonUtils.SOLOMON_REGISTRY;

class ActiveOrdersMetrics {
    private final Rate rollbackedCamps;
    private final Rate finishedCamps;
    private final Rate newShowsCamps;
    private final Rate unarchCamps;
    private final Rate moneyEndCamps;
    private final Rate updatedCampaigns;
    private final Labels solomonShardLabel;
    private final Rate resentCampaigns;

    ActiveOrdersMetrics(int shardNum) {
        var shardString = String.valueOf(shardNum);
        this.solomonShardLabel = Labels.of("shard", shardString);
        this.rollbackedCamps = SOLOMON_REGISTRY.rate("active_orders_rollbacked", solomonShardLabel);
        this.finishedCamps = SOLOMON_REGISTRY.rate("active_orders_finished", solomonShardLabel);
        this.newShowsCamps = SOLOMON_REGISTRY.rate("active_orders_new_shows", solomonShardLabel);
        this.unarchCamps = SOLOMON_REGISTRY.rate("active_orders_new_unarch", solomonShardLabel);
        this.moneyEndCamps = SOLOMON_REGISTRY.rate("active_orders_money_end", solomonShardLabel);
        this.updatedCampaigns = SOLOMON_REGISTRY.rate("active_orders_updated", solomonShardLabel);
        this.resentCampaigns = SOLOMON_REGISTRY.rate("active_orders_resent", solomonShardLabel);
    }

    void incrementRollbackedCamps() {
        rollbackedCamps.inc();
    }

    void incrementFinishedCamps() {
        finishedCamps.inc();
    }

    void incrementNewShowsCamps() {
        newShowsCamps.inc();
    }

    void incrementUnarchCamps() {
        unarchCamps.inc();
    }

    void incrementMoneyEndCamps() {
        moneyEndCamps.inc();
    }

    void addUpdatedCampaigns(long updatedCampaigns) {
        this.updatedCampaigns.add(updatedCampaigns);
    }

    void addResentCampaigns(long cnt) {
        this.resentCampaigns.add(cnt);
    }

    long getRollbackedCamps() {
        return rollbackedCamps.get();
    }

    long getFinishedCamps() {
        return finishedCamps.get();
    }

    long getNewShowsCamps() {
        return newShowsCamps.get();
    }

    long getUnarchCamps() {
        return unarchCamps.get();
    }

    long getMoneyEndCamps() {
        return moneyEndCamps.get();
    }

    /*
     * метод для тестов
     */
    void clearMetrics() {
        SOLOMON_REGISTRY.removeMetric("active_orders_rollbacked", solomonShardLabel);
        SOLOMON_REGISTRY.removeMetric("active_orders_finished", solomonShardLabel);
        SOLOMON_REGISTRY.removeMetric("active_orders_new_shows", solomonShardLabel);
        SOLOMON_REGISTRY.removeMetric("active_orders_new_unarch", solomonShardLabel);
        SOLOMON_REGISTRY.removeMetric("active_orders_money_end", solomonShardLabel);
        SOLOMON_REGISTRY.removeMetric("active_orders_updated", solomonShardLabel);
    }
}
