package ru.yandex.direct.jobs.statistics.advq;

import ru.yandex.inside.yt.kosher.cypress.YPath;

import static com.google.common.base.Preconditions.checkState;

public class AdvqHitsTablePath {

    private static final String ADVQ_TABLE_FOLDER = "//home/advq/advq/normal/rus/weeklyhits";
    private static final String ADVQ_TABLE_PARAMETER_NAME = "advq_totals";

    private final int year;
    private final int weekOfYear;

    private AdvqHitsTablePath(int year, int weekOfYear) {
        this.year = year;
        this.weekOfYear = weekOfYear;
    }

    public static AdvqHitsTablePath fromPropertyValue(String value) {
        String[] weekNumberParts = value.split("-");

        checkState(weekNumberParts.length == 2);

        int year = Integer.parseInt(weekNumberParts[0]);
        int weekOfYear = Integer.parseInt(weekNumberParts[1]);

        return new AdvqHitsTablePath(year, weekOfYear);
    }

    public String getPropertyValue() {
        return String.format("%d-%d", year, weekOfYear);
    }

    public AdvqHitsTablePath nextYear() {
        return new AdvqHitsTablePath(year + 1, 1);
    }

    public AdvqHitsTablePath nextWeek() {
        return new AdvqHitsTablePath(year, weekOfYear + 1);
    }

    public YPath toYPath() {
        String tableName = String.format("%d%02d", year, weekOfYear);
        return YPath.simple(ADVQ_TABLE_FOLDER + "/" + tableName + "/@" + ADVQ_TABLE_PARAMETER_NAME);
    }
}
