package ru.yandex.direct.jobs.statistics.advq;

import java.util.Map;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.statistics.AdvqHitsDeviceType;

import static java.util.function.Function.identity;

public enum ExportAdvqHitsDeviceType {

    DESKTOP("DesktopRegionHits"),
    PHONE("PhoneRegionHits"),
    TABLET("TabletRegionHits"),
    ALL("RegionHits");

    private final String advqName;

    private static final Map<String, ExportAdvqHitsDeviceType> STRING_TO_ENUM = StreamEx.of(ExportAdvqHitsDeviceType.values())
            .mapToEntry(deviceType -> deviceType.advqName, identity())
            .toMap();

    ExportAdvqHitsDeviceType(String advqName) {
        this.advqName = advqName;
    }

    public static ExportAdvqHitsDeviceType fromAdvq(String advqName) {
        return STRING_TO_ENUM.get(advqName);
    }

    public AdvqHitsDeviceType convertToCore() {
        return AdvqHitsDeviceType.valueOf(name());
    }
}
