package ru.yandex.direct.jobs.statistics.auctionstat;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.springframework.stereotype.Component;

import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.Counter;

import static ru.yandex.direct.solomon.SolomonUtils.SOLOMON_REGISTRY;

@Component
public class AuctionStatMetrics {

    private Map<Integer, Counter> updatedRowsCounter = new ConcurrentHashMap<>();

    public AuctionStatMetrics(ShardHelper shardHelper) {
        shardHelper.dbShards()
                .forEach(shard -> updatedRowsCounter.put(shard, SOLOMON_REGISTRY.counter(
                        "bs_auction_stat_updated_rows", Labels.of("shard", String.valueOf(shard)))));
    }

    void addUpdatedRows(int shard, int updatedRows) {
        updatedRowsCounter.get(shard).add(updatedRows);
    }

}
