package ru.yandex.direct.jobs.statistics.auctionstat;

import java.math.BigInteger;
import java.util.List;

import ru.yandex.direct.ytwrapper.model.YtField;
import ru.yandex.direct.ytwrapper.model.YtTableRow;

public class AuctionStatTableRow extends YtTableRow {

    private static final YtField<Long> PID = new YtField<>("pid", Long.class);
    private static final YtField<BigInteger> PHRASE_ID = new YtField<>("PhraseID", BigInteger.class);
    private static final YtField<Long> CLICKS = new YtField<>("clicks", Long.class);
    private static final YtField<Long> PCLICKS = new YtField<>("pclicks", Long.class);
    private static final YtField<Long> SHOWS = new YtField<>("shows", Long.class);
    private static final YtField<Long> PSHOWS = new YtField<>("pshows", Long.class);
    private static final YtField<Long> RANK = new YtField<>("rank", Long.class);

    AuctionStatTableRow() {
        super(List.of(PID, PHRASE_ID, CLICKS, PCLICKS, SHOWS, PSHOWS, RANK));
    }

    Long getPid() {
        return valueOf(PID);
    }

    BigInteger getPhraseId() {
        return valueOf(PHRASE_ID);
    }

    Long getClicks() {
        return valueOf(CLICKS);
    }

    Long getPclicks() {
        return valueOf(PCLICKS);
    }

    Long getShows() {
        return valueOf(SHOWS);
    }

    Long getPshows() {
        return valueOf(PSHOWS);
    }

    Long getRank() {
        return valueOf(RANK);
    }
}
