package ru.yandex.direct.jobs.statistics.rollbacknotifications;


import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.dbutil.model.ClientId;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class StatRollbackMailEvent {
    @JsonProperty
    private final StatRollbackEventType reason;

    @JsonProperty
    private final StatRollbacksMailNotificationType notification;

    @JsonProperty
    private final Long clientId;

    @JsonProperty
    private final Long uid;

    @JsonProperty
    private final String templateId;

    @JsonProperty
    private final String errorMessage;

    private StatRollbackMailEvent(StatRollbackEventType reason, ClientId clientId, User user,
                                  StatRollbacksMailNotificationType notification, String templateId,
                                  String errorMessage) {
        this.reason = reason;
        this.clientId = clientId.asLong();
        this.uid = user.getUid();
        this.notification = notification;
        this.templateId = templateId;
        this.errorMessage = errorMessage;
    }

    public static StatRollbackMailEvent mailSent(StatRollbacksMailNotificationType notification, ClientId clientId,
                                                 User user, String templateId) {
        return new StatRollbackMailEvent(StatRollbackEventType.MAIL_SENT, clientId, user, notification,
                templateId,
                null);
    }

    public static StatRollbackMailEvent statRollbackBadEmail(ClientId clientId, User user, String email) {
        return new StatRollbackMailEvent(StatRollbackEventType.BAD_EMAIL, clientId, user, null, null, email);
    }

    public static StatRollbackMailEvent statRollbackEmptySlug(ClientId clientId, User user, String email) {
        return new StatRollbackMailEvent(StatRollbackEventType.EMPTY_SLUG, clientId, user, null, null, email);
    }

    public static StatRollbackMailEvent senderError(StatRollbacksMailNotificationType notification, ClientId clientId,
                                                    User user, String templateId, String errorMessage) {
        return new StatRollbackMailEvent(StatRollbackEventType.SENDER_ERROR, clientId, user, notification,
                templateId,
                errorMessage);
    }

    public enum StatRollbackEventType {
        BAD_EMAIL,
        MAIL_SENT,
        EMPTY_SLUG,
        SENDER_ERROR
    }
}
