package ru.yandex.direct.jobs.statistics.rollbacknotifications;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import ru.yandex.direct.i18n.Language;

public class StatRollbacksMailTemplateResolver {
    private final Map<Language, Map<StatRollbacksMailNotificationType, String>> templateMapping;
    private final Set<Language> allTemplatesLanguages;

    public StatRollbacksMailTemplateResolver(Map<Language, Map<StatRollbacksMailNotificationType, String>> templateMapping) {
        this.templateMapping = templateMapping;
        this.allTemplatesLanguages = getAllLanguagesWithTemplates(templateMapping);
    }

    public String resolveTemplateId(Language lang, StatRollbacksMailNotificationType notification) {
        // Если в шаблонах нет нужного языка - отправляем письмо на русском
        Language userLang = allTemplatesLanguages.contains(lang) ? lang : Language.RU;
        Map<StatRollbacksMailNotificationType, String> mappingsForLang = templateMapping.get(userLang);
        return mappingsForLang == null ? null : mappingsForLang.get(notification);
    }

    // возвращает все языки для которых есть шаблоны писем
    private Set<Language> getAllLanguagesWithTemplates(Map<Language, Map<StatRollbacksMailNotificationType, String>> templateMapping) {
        return templateMapping.entrySet().stream()
                .filter(r -> !r.getValue().isEmpty())
                .map(r -> r.getKey())
                .collect(Collectors.toSet());
    }
}
