package ru.yandex.direct.jobs.suggestconversionprice.config;

import ru.yandex.direct.config.DirectConfig;

public class ConversionPriceJobConfig {

    private final DirectConfig config;

    private static final String SUGGEST_CONVERSION_PRICE_CONFIG_BRANCH = "suggest_conversion_price";
    private static final String SOURCE_CLUSTER = "source_cluster";
    private static final String SOURCE_TABLE_DIR_PATH = "source_table_dir_path";
    private static final String TARGET_CLUSTER = "target_cluster";
    private static final String TARGET_TABLE_RELATIVE_PATH = "target_table_relative_path";

    public ConversionPriceJobConfig(DirectConfig directConfig) {
        config = directConfig.getBranch(SUGGEST_CONVERSION_PRICE_CONFIG_BRANCH);
    }

    public String getSourceCluster() {
        return config.getString(SOURCE_CLUSTER);
    }

    public String getTargetCluster() {
        return config.getString(TARGET_CLUSTER);
    }

    public String getSourceTableDirPath() {
        return config.getString(SOURCE_TABLE_DIR_PATH);
    }

    public String getTargetTableRelativePath() {
        return config.getString(TARGET_TABLE_RELATIVE_PATH);
    }

}
