package ru.yandex.direct.jobs.takeout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.common.collect.ImmutableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.addition.callout.model.Callout;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionVideoAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.CpmBannerAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.CpmIndoorAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.CpmOutdoorAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.CpmVideoAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.CpmYndxFrontpageAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.DynamicFeedAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.DynamicTextAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.McBannerAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.MobileContentAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.PerformanceAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.TextAdGroup;
import ru.yandex.direct.core.entity.banner.model.BannerPrice;
import ru.yandex.direct.core.entity.banner.model.BannerWithHref;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.model.CpcVideoBanner;
import ru.yandex.direct.core.entity.banner.model.CpmBanner;
import ru.yandex.direct.core.entity.banner.model.CpmOutdoorBanner;
import ru.yandex.direct.core.entity.banner.model.DynamicBanner;
import ru.yandex.direct.core.entity.banner.model.ImageBanner;
import ru.yandex.direct.core.entity.banner.model.MobileAppBanner;
import ru.yandex.direct.core.entity.banner.model.PerformanceBanner;
import ru.yandex.direct.core.entity.banner.model.TextBanner;
import ru.yandex.direct.core.entity.bidmodifier.BidModifier;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierABSegment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierABSegmentAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierBannerType;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierBannerTypeAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDemographics;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDemographicsAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDesktop;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDesktopAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierGeo;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierInventory;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierInventoryAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierMobile;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierMobileAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierPerformanceTgo;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierPerformanceTgoAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierRegionalAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierRetargeting;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierRetargetingAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierVideo;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierVideoAdjustment;
import ru.yandex.direct.core.entity.campaign.model.Campaign;
import ru.yandex.direct.core.entity.campaign.model.CampaignOpts;
import ru.yandex.direct.core.entity.campaign.model.DbStrategy;
import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.core.entity.client.model.Client;
import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.feed.model.Feed;
import ru.yandex.direct.core.entity.keyword.model.Keyword;
import ru.yandex.direct.core.entity.mobilecontent.model.MobileContent;
import ru.yandex.direct.core.entity.performancefilter.model.PerformanceFilter;
import ru.yandex.direct.core.entity.performancefilter.model.PerformanceFilterCondition;
import ru.yandex.direct.core.entity.relevancematch.model.RelevanceMatch;
import ru.yandex.direct.core.entity.retargeting.model.TargetInterest;
import ru.yandex.direct.core.entity.sitelink.model.Sitelink;
import ru.yandex.direct.core.entity.turbolanding.model.TurboLanding;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.core.entity.vcard.model.Phone;
import ru.yandex.direct.core.entity.vcard.model.Vcard;
import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

import static org.apache.commons.collections4.ListUtils.union;

@Component
class TakeoutRules {
    private static final Logger log = LoggerFactory.getLogger(TakeoutRules.class);
    //класс модели -> список полей
    private static final Map<Class<? extends Model>, List<ModelProperty>> FIELDS = fields();

    public static final Set<CampaignOpts> AVAILABLE_CAMPAIGN_OPTIONS = ImmutableSet.<CampaignOpts>builder()
            .add(CampaignOpts.ENABLE_CPC_HOLD)
            .add(CampaignOpts.NO_TITLE_SUBSTITUTE)
            .add(CampaignOpts.HIDE_PERMALINK_INFO)
            .add(CampaignOpts.NO_EXTENDED_GEOTARGETING)
            .build();

    private static Map<Class<? extends Model>, List<ModelProperty>> fields() {
        Map<Class<? extends Model>, List<ModelProperty>> modelPropertyMap = new HashMap<>();
        List<ModelProperty> campaign = new ArrayList<>();
        campaign.add(Campaign.ID);
        campaign.add(Campaign.CLIENT_ID);
        campaign.add(Campaign.TYPE);
        campaign.add(Campaign.CURRENCY);
        campaign.add(Campaign.EMAIL);
        campaign.add(Campaign.START_TIME);
        campaign.add(Campaign.FINISH_TIME);
        campaign.add(Campaign.GEO);
        campaign.add(Campaign.CONTEXT_PRICE_COEF);
        campaign.add(Campaign.MINUS_KEYWORDS);
        campaign.add(Campaign.DISABLED_DOMAINS);
        campaign.add(Campaign.DISABLED_SSP);
        campaign.add(Campaign.STRATEGY);
        campaign.add(Campaign.NAME);
        campaign.add(Campaign.SMS_FLAGS);
        campaign.add(Campaign.DEVICE_TARGETING);
        campaign.add(Campaign.MOBILE_APP_GOAL);
        modelPropertyMap.put(Campaign.class, campaign);

        List<ModelProperty> dbStrategy = new ArrayList<>();
        dbStrategy.add(DbStrategy.STRATEGY_NAME);
        dbStrategy.add(DbStrategy.PLATFORM);
        dbStrategy.add(DbStrategy.DAY_BUDGET);
        dbStrategy.add(DbStrategy.DAY_BUDGET_SHOW_MODE);
        dbStrategy.add(DbStrategy.STRATEGY_DATA);
        modelPropertyMap.put(DbStrategy.class, dbStrategy);

        List<ModelProperty> strategyData = new ArrayList<>();
        strategyData.add(StrategyData.DATE);
        strategyData.add(StrategyData.NAME);
        strategyData.add(StrategyData.PLACE);
        strategyData.add(StrategyData.AVG_BID);
        strategyData.add(StrategyData.AVG_CPI);
        strategyData.add(StrategyData.BID);
        strategyData.add(StrategyData.SUM);
        strategyData.add(StrategyData.ROI_COEF);
        strategyData.add(StrategyData.RESERVE_RETURN);
        strategyData.add(StrategyData.PROFITABILITY);
        strategyData.add(StrategyData.LIMIT_CLICKS);
        strategyData.add(StrategyData.GOAL_ID);
        strategyData.add(StrategyData.FILTER_AVG_CPA);
        strategyData.add(StrategyData.FILTER_AVG_BID);
        strategyData.add(StrategyData.PAY_FOR_CONVERSION);
        modelPropertyMap.put(StrategyData.class, strategyData);

        List<ModelProperty> adGroup = new ArrayList<>();
        adGroup.add(AdGroup.NAME);
        adGroup.add(AdGroup.TYPE);
        adGroup.add(AdGroup.GEO);
        adGroup.add(AdGroup.TRACKING_PARAMS);
        adGroup.add(AdGroup.MINUS_KEYWORDS);

        List<ModelProperty> mobileContentAdGroup = new ArrayList<>();
        mobileContentAdGroup.add(MobileContentAdGroup.DEVICE_TYPE_TARGETING);
        mobileContentAdGroup.add(MobileContentAdGroup.MINIMAL_OPERATING_SYSTEM_VERSION);
        mobileContentAdGroup.add(MobileContentAdGroup.MOBILE_CONTENT);
        mobileContentAdGroup.add(MobileContentAdGroup.NETWORK_TARGETING);
        mobileContentAdGroup.add(MobileContentAdGroup.STORE_URL);
        modelPropertyMap.put(MobileContentAdGroup.class, union(adGroup, mobileContentAdGroup));

        List<ModelProperty> mobileContent = new ArrayList<>();
        mobileContent.add(MobileContent.NAME);
        mobileContent.add(MobileContent.GENRE);
        mobileContent.add(MobileContent.APP_SIZE);
        mobileContent.add(MobileContent.OS_TYPE);
        mobileContent.add(MobileContent.MIN_OS_VERSION);
        mobileContent.add(MobileContent.PRICES);
        mobileContent.add(MobileContent.RATING);
        modelPropertyMap.put(MobileContent.class, mobileContent);

        List<ModelProperty> cpmBannerAdGroup = new ArrayList<>();
        cpmBannerAdGroup.add(CpmBannerAdGroup.CRITERION_TYPE);
        modelPropertyMap.put(CpmBannerAdGroup.class, union(adGroup, cpmBannerAdGroup));

        List<ModelProperty> performanceAdGroup = new ArrayList<>();
        performanceAdGroup.add(PerformanceAdGroup.FIELD_TO_USE_AS_NAME);
        performanceAdGroup.add(PerformanceAdGroup.FIELD_TO_USE_AS_BODY);
        performanceAdGroup.add(PerformanceAdGroup.FEED_ID);
        modelPropertyMap.put(PerformanceAdGroup.class, union(adGroup, performanceAdGroup));

        List<ModelProperty> dynamicTextAdGroup = new ArrayList<>();
        dynamicTextAdGroup.add(DynamicTextAdGroup.DOMAIN_URL);
        modelPropertyMap.put(DynamicTextAdGroup.class, union(adGroup, dynamicTextAdGroup));

        List<ModelProperty> dynamicFeedAdGroup = new ArrayList<>();
        dynamicFeedAdGroup.add(DynamicFeedAdGroup.FEED_ID);
        modelPropertyMap.put(DynamicFeedAdGroup.class, union(adGroup, dynamicFeedAdGroup));

        List<ModelProperty> cpmIndoorAdGroup = new ArrayList<>();
        cpmIndoorAdGroup.add(CpmIndoorAdGroup.PAGE_BLOCKS);
        modelPropertyMap.put(CpmIndoorAdGroup.class, union(adGroup, cpmIndoorAdGroup));

        List<ModelProperty> cpmOutdoorAdGroup = new ArrayList<>();
        cpmOutdoorAdGroup.add(CpmOutdoorAdGroup.PAGE_BLOCKS);
        modelPropertyMap.put(CpmOutdoorAdGroup.class, union(adGroup, cpmOutdoorAdGroup));

        modelPropertyMap.put(TextAdGroup.class, adGroup);
        modelPropertyMap.put(CpmYndxFrontpageAdGroup.class, adGroup);
        modelPropertyMap.put(CpmVideoAdGroup.class, adGroup);
        modelPropertyMap.put(McBannerAdGroup.class, adGroup);
        modelPropertyMap.put(ContentPromotionVideoAdGroup.class, adGroup);

        List<ModelProperty> banner = new ArrayList<>();
        banner.add(BannerWithSystemFields.STATUS_ACTIVE);
        banner.add(BannerWithSystemFields.STATUS_ARCHIVED);
        banner.add(BannerWithSystemFields.AD_GROUP_ID);
        banner.add(BannerWithHref.HREF);

        List<ModelProperty> vCard = new ArrayList<>();
        vCard.add(Vcard.PRECISION);
        vCard.add(Vcard.OGRN);
        vCard.add(Vcard.MANUAL_POINT);
        vCard.add(Vcard.INSTANT_MESSENGER);
        vCard.add(Vcard.EMAIL);
        vCard.add(Vcard.COUNTRY);
        vCard.add(Vcard.CONTACT_PERSON);
        vCard.add(Vcard.CITY);
        vCard.add(Vcard.BUILD);
        vCard.add(Vcard.APART);
        vCard.add(Vcard.WORK_TIME);
        vCard.add(Vcard.COMPANY_NAME);
        vCard.add(Vcard.EXTRA_MESSAGE);
        vCard.add(Vcard.PHONE);
        vCard.add(Vcard.HOUSE);
        vCard.add(Vcard.STREET);
        modelPropertyMap.put(Vcard.class, vCard);

        List<ModelProperty> phone = new ArrayList<>();
        phone.add(Phone.COUNTRY_CODE);
        phone.add(Phone.CITY_CODE);
        phone.add(Phone.PHONE_NUMBER);
        phone.add(Phone.EXTENSION);
        modelPropertyMap.put(Phone.class, phone);

        List<ModelProperty> sitelink = new ArrayList<>();
        sitelink.add(Sitelink.TITLE);
        sitelink.add(Sitelink.DESCRIPTION);
        sitelink.add(Sitelink.HREF);
        sitelink.add(Sitelink.ORDER_NUM);
        modelPropertyMap.put(Sitelink.class, sitelink);

        List<ModelProperty> callout = new ArrayList<>();
        callout.add(Callout.ID);
        callout.add(Callout.TEXT);
        modelPropertyMap.put(Callout.class, callout);

        List<ModelProperty> turbolanding = new ArrayList<>();
        turbolanding.add(TurboLanding.ID);
        turbolanding.add(TurboLanding.NAME);
        turbolanding.add(TurboLanding.PREVIEW_HREF);
        turbolanding.add(TurboLanding.URL);
        turbolanding.add(TurboLanding.METRIKA_COUNTERS);
        modelPropertyMap.put(TurboLanding.class, turbolanding);

        List<ModelProperty> creative = new ArrayList<>();
        creative.add(Creative.NAME);
        creative.add(Creative.TYPE);
        creative.add(Creative.BUSINESS_TYPE);
        creative.add(Creative.SOURCE_MEDIA_TYPE);
        creative.add(Creative.DURATION);
        creative.add(Creative.WIDTH);
        creative.add(Creative.HEIGHT);
        creative.add(Creative.PREVIEW_URL);
        creative.add(Creative.LIVE_PREVIEW_URL);
        modelPropertyMap.put(Creative.class, creative);

        List<ModelProperty> textBanner = new ArrayList<>();
        textBanner.add(TextBanner.IS_MOBILE);
        textBanner.add(TextBanner.TITLE);
        textBanner.add(TextBanner.TITLE_EXTENSION);
        textBanner.add(TextBanner.BODY);
        textBanner.add(TextBanner.DISPLAY_HREF);
        textBanner.add(TextBanner.BANNER_PRICE);
        textBanner.add(TextBanner.TURBO_LANDING_HREF_PARAMS);
        modelPropertyMap.put(TextBanner.class, union(banner, textBanner));

        List<ModelProperty> bannerPrice = new ArrayList<>();
        bannerPrice.add(BannerPrice.PRICE);
        bannerPrice.add(BannerPrice.PRICE_OLD);
        bannerPrice.add(BannerPrice.CURRENCY);
        bannerPrice.add(BannerPrice.PREFIX);
        modelPropertyMap.put(BannerPrice.class, bannerPrice);

        List<ModelProperty> dynamicBanner = new ArrayList<>();
        dynamicBanner.add(DynamicBanner.BODY);
        dynamicBanner.add(DynamicBanner.DISPLAY_HREF);
        modelPropertyMap.put(DynamicBanner.class, union(banner, dynamicBanner));

        List<ModelProperty> cpmBanner = new ArrayList<>();
        cpmBanner.add(CpmBanner.PIXELS);
        modelPropertyMap.put(CpmBanner.class, union(banner, cpmBanner));

        List<ModelProperty> cpcVideoBanner = new ArrayList<>();
        cpcVideoBanner.add(CpcVideoBanner.TITLE);
        cpcVideoBanner.add(CpcVideoBanner.BODY);
        modelPropertyMap.put(CpcVideoBanner.class, union(banner, cpcVideoBanner));

        List<ModelProperty> mobileAppBanner = new ArrayList<>();
        mobileAppBanner.add(MobileAppBanner.BODY);
        mobileAppBanner.add(MobileAppBanner.TITLE);
        mobileAppBanner.add(MobileAppBanner.PRIMARY_ACTION);
        mobileAppBanner.add(MobileAppBanner.REFLECTED_ATTRIBUTES);
        mobileAppBanner.add(MobileAppBanner.IMPRESSION_URL);
        modelPropertyMap.put(MobileAppBanner.class, union(banner, mobileAppBanner));

        modelPropertyMap.put(ImageBanner.class, banner);
        modelPropertyMap.put(PerformanceBanner.class, banner);
        modelPropertyMap.put(CpmOutdoorBanner.class, banner);

        List<ModelProperty> keyword = new ArrayList<>();
        keyword.add(Keyword.PHRASE);
        keyword.add(Keyword.PRICE);
        keyword.add(Keyword.PRICE_CONTEXT);
        keyword.add(Keyword.AUTOBUDGET_PRIORITY);
        keyword.add(Keyword.HREF_PARAM1);
        keyword.add(Keyword.HREF_PARAM2);
        keyword.add(Keyword.IS_SUSPENDED);
        modelPropertyMap.put(Keyword.class, keyword);

        List<ModelProperty> targetInterest = new ArrayList<>();
        targetInterest.add(TargetInterest.PRICE_CONTEXT);
        targetInterest.add(TargetInterest.AUTOBUDGET_PRIORITY);
        targetInterest.add(TargetInterest.INTEREST_ID);
        modelPropertyMap.put(TargetInterest.class, targetInterest);

        List<ModelProperty> performanceFilter = new ArrayList<>();
        performanceFilter.add(PerformanceFilter.NAME);
        performanceFilter.add(PerformanceFilter.IS_SUSPENDED);
        performanceFilter.add(PerformanceFilter.IS_DELETED);
        performanceFilter.add(PerformanceFilter.PRICE_CPC);
        performanceFilter.add(PerformanceFilter.PRICE_CPA);
        performanceFilter.add(PerformanceFilter.AUTOBUDGET_PRIORITY);
        performanceFilter.add(PerformanceFilter.TARGET_FUNNEL);
        performanceFilter.add(PerformanceFilter.CONDITIONS);
        modelPropertyMap.put(PerformanceFilter.class, performanceFilter);

        List<ModelProperty> performanceFilterCondition = new ArrayList<>();
        performanceFilterCondition.add(PerformanceFilterCondition.FIELD_NAME);
        performanceFilterCondition.add(PerformanceFilterCondition.OPERATOR);
        performanceFilterCondition.add(PerformanceFilterCondition.STRING_VALUE);
        modelPropertyMap.put(PerformanceFilterCondition.class, performanceFilterCondition);

        List<ModelProperty> relevanceMatch = new ArrayList<>();
        relevanceMatch.add(RelevanceMatch.PRICE);
        relevanceMatch.add(RelevanceMatch.PRICE_CONTEXT);
        relevanceMatch.add(RelevanceMatch.AUTOBUDGET_PRIORITY);
        relevanceMatch.add(RelevanceMatch.HREF_PARAM1);
        relevanceMatch.add(RelevanceMatch.HREF_PARAM2);
        relevanceMatch.add(RelevanceMatch.IS_DELETED);
        relevanceMatch.add(RelevanceMatch.IS_SUSPENDED);
        modelPropertyMap.put(RelevanceMatch.class, relevanceMatch);

        List<ModelProperty> client = new ArrayList<>();
        client.add(Client.NAME);
        client.add(Client.WORK_CURRENCY);
        modelPropertyMap.put(Client.class, client);

        List<ModelProperty> user = new ArrayList<>();
        user.add(User.EMAIL);
        user.add(User.RECOMMENDATIONS_EMAIL);
        user.add(User.FIO);
        user.add(User.PHONE);
        user.add(User.LANG);
        user.add(User.SEND_WARN);
        user.add(User.SEND_NEWS);
        user.add(User.SEND_ACC_NEWS);
        modelPropertyMap.put(User.class, user);

        List<ModelProperty> bidModifiers = new ArrayList<>();
        bidModifiers.add(BidModifier.ENABLED);
        bidModifiers.add(BidModifier.TYPE);

        List<ModelProperty> bidModifierAdjustment = new ArrayList<>();
        bidModifierAdjustment.add(BidModifierAdjustment.PERCENT);

        List<ModelProperty> bidModifierABSegment = new ArrayList<>();
        bidModifierABSegment.add(BidModifierABSegment.AB_SEGMENT_ADJUSTMENTS);
        modelPropertyMap.put(BidModifierABSegment.class, union(bidModifiers, bidModifierABSegment));

        List<ModelProperty> bidModifierABSegmentAdjustment = new ArrayList<>();
        bidModifierABSegmentAdjustment.add(BidModifierABSegmentAdjustment.ACCESSIBLE);
        bidModifierABSegmentAdjustment.add(BidModifierABSegmentAdjustment.AB_SEGMENT_RETARGETING_CONDITION_ID);
        bidModifierABSegmentAdjustment.add(BidModifierABSegmentAdjustment.SECTION_ID);
        bidModifierABSegmentAdjustment.add(BidModifierABSegmentAdjustment.SEGMENT_ID);
        modelPropertyMap.put(BidModifierABSegmentAdjustment.class,
                union(bidModifierAdjustment, bidModifierABSegmentAdjustment));

        List<ModelProperty> bidModifierBannerType = new ArrayList<>();
        bidModifierBannerType.add(BidModifierBannerType.BANNER_TYPE_ADJUSTMENTS);
        modelPropertyMap.put(BidModifierBannerType.class, union(bidModifiers, bidModifierBannerType));

        List<ModelProperty> bidModifierBannerTypeAdjustment = new ArrayList<>();
        bidModifierBannerTypeAdjustment.add(BidModifierBannerTypeAdjustment.BANNER_TYPE);
        modelPropertyMap.put(BidModifierBannerTypeAdjustment.class,
                union(bidModifierAdjustment, bidModifierBannerTypeAdjustment));

        List<ModelProperty> bidModifierDemographics = new ArrayList<>();
        bidModifierDemographics.add(BidModifierDemographics.DEMOGRAPHICS_ADJUSTMENTS);
        modelPropertyMap.put(BidModifierDemographics.class, union(bidModifiers, bidModifierDemographics));

        List<ModelProperty> bidModifierDemographicsAdjustment = new ArrayList<>();
        bidModifierDemographicsAdjustment.add(BidModifierDemographicsAdjustment.AGE);
        bidModifierDemographicsAdjustment.add(BidModifierDemographicsAdjustment.GENDER);
        modelPropertyMap.put(BidModifierDemographicsAdjustment.class,
                union(bidModifierAdjustment, bidModifierDemographicsAdjustment));

        modelPropertyMap.put(BidModifierDesktop.class, bidModifiers);
        modelPropertyMap.put(BidModifierDesktopAdjustment.class, bidModifierAdjustment);

        List<ModelProperty> bidModifierGeo = new ArrayList<>();
        bidModifierGeo.add(BidModifierGeo.REGIONAL_ADJUSTMENTS);
        modelPropertyMap.put(BidModifierGeo.class, union(bidModifiers, bidModifierGeo));

        List<ModelProperty> bidModifierRegionalAdjustment = new ArrayList<>();
        bidModifierRegionalAdjustment.add(BidModifierRegionalAdjustment.REGION_ID);
        bidModifierRegionalAdjustment.add(BidModifierRegionalAdjustment.HIDDEN);
        modelPropertyMap.put(BidModifierRegionalAdjustment.class,
                union(bidModifierAdjustment, bidModifierRegionalAdjustment));

        List<ModelProperty> bidModifierInventory = new ArrayList<>();
        bidModifierInventory.add(BidModifierInventory.INVENTORY_ADJUSTMENTS);
        modelPropertyMap.put(BidModifierInventory.class, union(bidModifiers, bidModifierInventory));

        List<ModelProperty> bidModifierInventoryAdjustment = new ArrayList<>();
        bidModifierInventoryAdjustment.add(BidModifierInventoryAdjustment.INVENTORY_TYPE);
        modelPropertyMap.put(BidModifierInventoryAdjustment.class,
                union(bidModifierAdjustment, bidModifierInventoryAdjustment));

        List<ModelProperty> bidModifierMobile = new ArrayList<>();
        bidModifierMobile.add(BidModifierMobile.MOBILE_ADJUSTMENT);
        modelPropertyMap.put(BidModifierMobile.class, union(bidModifiers, bidModifierMobile));

        List<ModelProperty> bidModifierMobileAdjustment = new ArrayList<>();
        bidModifierMobileAdjustment.add(BidModifierMobileAdjustment.OS_TYPE);
        modelPropertyMap.put(BidModifierMobileAdjustment.class,
                union(bidModifierAdjustment, bidModifierMobileAdjustment));

        List<ModelProperty> bidModifierPerformanceTgo = new ArrayList<>();
        bidModifierPerformanceTgo.add(BidModifierPerformanceTgo.PERFORMANCE_TGO_ADJUSTMENT);
        modelPropertyMap.put(BidModifierPerformanceTgo.class, union(bidModifiers, bidModifierPerformanceTgo));

        modelPropertyMap.put(BidModifierPerformanceTgoAdjustment.class, bidModifierAdjustment);

        List<ModelProperty> bidModifierRetargeting = new ArrayList<>();
        bidModifierRetargeting.add(BidModifierRetargeting.RETARGETING_ADJUSTMENTS);
        modelPropertyMap.put(BidModifierRetargeting.class, union(bidModifiers, bidModifierRetargeting));

        List<ModelProperty> bidModifierRetargetingAdjustment = new ArrayList<>();
        bidModifierRetargetingAdjustment.add(BidModifierRetargetingAdjustment.RETARGETING_CONDITION_ID);
        bidModifierRetargetingAdjustment.add(BidModifierRetargetingAdjustment.ACCESSIBLE);
        modelPropertyMap.put(BidModifierRetargetingAdjustment.class,
                union(bidModifierAdjustment, bidModifierRetargetingAdjustment));

        List<ModelProperty> bidModifierVideo = new ArrayList<>();
        bidModifierVideo.add(BidModifierVideo.VIDEO_ADJUSTMENT);
        modelPropertyMap.put(BidModifierVideo.class, union(bidModifiers, bidModifierVideo));

        modelPropertyMap.put(BidModifierVideoAdjustment.class, bidModifierAdjustment);

        List<ModelProperty> feed = new ArrayList<>();
        feed.add(Feed.ID);
        feed.add(Feed.FILENAME);
        feed.add(Feed.URL);
        feed.add(Feed.SOURCE);
        feed.add(Feed.BUSINESS_TYPE);
        feed.add(Feed.FEED_TYPE);
        feed.add(Feed.IS_REMOVE_UTM);
        modelPropertyMap.put(Feed.class, feed);

        return modelPropertyMap;
    }

    /**
     * Получить мапу с данными модели согласно заданным правилам
     */
    <M extends Model> Map<String, Object> exportModel(M model) {
        Map<String, Object> export = new HashMap<>();
        if (!hasRules(model)) {
            return export;
        }
        //берутся только те поля модели, которые заданы в правилах
        for (ModelProperty modelProperty : getRules(model)) {
            //в правилах могут быть заданы общие поля, которых нет в конечных классах, их пропускаем
            if(!modelProperty.getModelClass().isAssignableFrom(model.getClass())) {
                log.info("{} does not have attribute {}", model.getClass(), modelProperty.getModelClass());
                continue;
            }
            Object val = modelProperty.get(model);
            if (isEmpty(val)) {
                continue;
            }
            //если поле — коллекция, обрабатывается каждый элемент
            if (val instanceof Collection) {
                List<Object> models = new ArrayList<>();
                for (Object o : (Collection) val) {
                    if (o instanceof Model) {
                        models.add(exportModel((Model) o));
                    } else {
                        models.add(o);
                    }
                }
                if (!models.isEmpty()) {
                    export.put(modelProperty.name(), models);
                }
            } else {
                if (hasRules(val)) {
                    export.put(modelProperty.name(), exportModel((Model) val));
                } else {
                    export.put(modelProperty.name(), val);
                }
            }
        }
        return export;
    }

    private boolean hasRules(Object object) {
        if (object == null) {
            return false;
        }
        return FIELDS.containsKey(object.getClass());
    }

    private List<ModelProperty> getRules(Model model) {
        return FIELDS.getOrDefault(model.getClass(), Collections.emptyList());
    }

    private boolean isEmpty(Object val) {
        if (val == null) {
            return true;
        }
        if (val instanceof List) {
            return ((List) val).isEmpty();
        }
        if (val instanceof Set) {
            return ((Set) val).isEmpty();
        }
        if (val instanceof Map) {
            return ((Map) val).isEmpty();
        }
        if (val instanceof String) {
            return ((String) val).isEmpty();
        }
        return false;
    }
}
