package ru.yandex.direct.jobs.telephony;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.TextFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.binlogbroker.logbroker_utils.reader.impl.LogbrokerBatchReaderImpl;
import ru.yandex.kikimr.persqueue.consumer.SyncConsumer;
import ru.yandex.kikimr.persqueue.consumer.transport.message.inbound.data.MessageBatch;
import ru.yandex.kikimr.persqueue.consumer.transport.message.inbound.data.MessageData;
import ru.yandex.telephony.backend.lib.proto.telephony_platform.ServiceNumberAction;
import ru.yandex.telephony.backend.lib.proto.telephony_platform.ServiceNumberActionBatch;

public class TelephonyServiceNumberActionReader extends LogbrokerBatchReaderImpl<ServiceNumberAction> {

    private static final Logger logger = LoggerFactory.getLogger(TelephonyServiceNumberActionReader.class);

    public TelephonyServiceNumberActionReader(
            Supplier<SyncConsumer> logbrokerConsumerSupplier,
            boolean logbrokerNoCommit
    ) {
        super(logbrokerConsumerSupplier, logbrokerNoCommit);
    }

    @Override
    protected List<ServiceNumberAction> batchDeserialize(MessageBatch messageBatch) {
        List<ServiceNumberAction> actions = new ArrayList<>();
        for (MessageData messageData : messageBatch.getMessageData()) {
            try {
                var parsedActions = ServiceNumberActionBatch.parseFrom(messageData.getDecompressedData());
                logger.info("Object - {}", TextFormat.shortDebugString(parsedActions));
                actions.addAll(parsedActions.getActionsList());
            } catch (InvalidProtocolBufferException e) {
                logger.error("Failed to parse message", e);
            }
        }
        return actions;
    }

    @Override
    protected int count(List<ServiceNumberAction> e) {
        return e.size();
    }
}
