package ru.yandex.direct.jobs.uac

import ru.yandex.direct.ansiblejuggler.model.notifications.NotificationMethod
import ru.yandex.direct.core.entity.dbqueue.DbQueueJobTypes
import ru.yandex.direct.dbqueue.repository.DbQueueRepository
import ru.yandex.direct.env.NonDevelopmentEnvironment
import ru.yandex.direct.env.ProductionOnly
import ru.yandex.direct.jobs.base.dbqueuemonitoring.BaseDbQueueMonitoringJob
import ru.yandex.direct.juggler.check.annotation.JugglerCheck
import ru.yandex.direct.juggler.check.annotation.OnChangeNotification
import ru.yandex.direct.juggler.check.model.CheckTag
import ru.yandex.direct.juggler.check.model.NotificationRecipient
import ru.yandex.direct.scheduler.Hourglass
import ru.yandex.direct.scheduler.HourglassDaemon

/**
 * Джоба, отправляющая в Соломон метрики по очереди кампаний для обработки джобой [UpdateAdsJob]:
 * размер, возраст, кол-во ожидающих клиентов
 */
@JugglerCheck(
    ttl = JugglerCheck.Duration(minutes = 10),
    tags = [CheckTag.DIRECT_PRIORITY_1_NOT_READY],
    notifications = [
        OnChangeNotification(
            recipient = [NotificationRecipient.CHAT_UC_API_MONITORING],
            method = [NotificationMethod.TELEGRAM],
        ),
    ],
    needCheck = ProductionOnly::class,
)
@HourglassDaemon(runPeriod = 60)
@Hourglass(periodInSeconds = 60, needSchedule = NonDevelopmentEnvironment::class)
class UacUpdateAdsQueueMonitoringJob(
    dbQueueRepository: DbQueueRepository,
) : BaseDbQueueMonitoringJob(dbQueueRepository) {

    override fun dbQueueJobType() = DbQueueJobTypes.UAC_UPDATE_ADS
    override fun typeLabel() = DbQueueJobTypes.UAC_UPDATE_ADS.name
}
