package ru.yandex.direct.jobs.uac

import ru.yandex.direct.core.entity.uac.model.MediaType
import ru.yandex.direct.core.entity.uac.model.request.UacAdGroupBrief
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbCampaignContent
import ru.yandex.direct.jobs.uac.model.UacBanner

object UpdateAdsJobUtil {

    fun groupCampaignContentByType(
        uacCampaignContents: List<UacYdbCampaignContent>
    ): Map<MediaType, List<UacYdbCampaignContent>> {
        return uacCampaignContents
            .filter { it.type != null }
            .groupBy { it.type!! }
    }

    /**
     * Возвращает маппинг id -> CampaignContent заданного типа {@param type}
     */
    fun getIdToCampaignContentByType(
        uacCampaignContents: List<UacYdbCampaignContent>,
        type: MediaType,
    ): Map<String, UacYdbCampaignContent> {
        return uacCampaignContents
            .filter { it.type == type }
            .associateBy { it.id }
    }

    fun getIdToCampaignContentByTypes(
        uacCampaignContents: List<UacYdbCampaignContent>,
        type: Set<MediaType>,
    ): Map<String, UacYdbCampaignContent> {
        return uacCampaignContents
            .filter { type.contains(it.type) }
            .associateBy { it.id }
    }

    /**
     *  Возвращает все баннеры, сгруппированные по групповым заявкам
     *
     *  @param uacBanners баннеры
     *  @param uacAdGroupBriefs групповые заявки
     *  @param adGroupIdByBannerId маппа <bid, pid>
     */
    fun getUacBannersByBriefId(
        uacBanners: List<UacBanner>,
        uacAdGroupBriefs: List<UacAdGroupBrief>,
        adGroupIdByBannerId: Map<Long, Long>,
    ): Map<Long?, List<UacBanner>> {
        val uacBannerByBid = uacBanners
            .associateBy { it.bid }
        val uacBannersByAdGroupId = adGroupIdByBannerId
            .mapKeys { uacBannerByBid[it.key] }
            .filterKeys { it != null }
            .asSequence()
            .groupBy({ it.value }, { it.key!! })
        return uacAdGroupBriefs
            .associate { it.adGroupBriefId to it.adGroupIds }
            .mapValues { (_, directAdGroupIds) ->
                directAdGroupIds
                    ?.mapNotNull { directAdGroupId -> uacBannersByAdGroupId[directAdGroupId] }
                    ?.flatten() ?: emptyList()
            }
    }

    val migratingOperatorUid: Long
        get() = 933325662L // yndx-ulyashevda-super
}

