package ru.yandex.direct.jobs.uac.logbroker

import NBannerLand.Banner
import com.google.protobuf.InvalidProtocolBufferException
import com.google.protobuf.TextFormat
import org.slf4j.LoggerFactory
import ru.yandex.direct.binlogbroker.logbroker_utils.reader.impl.LogbrokerBatchReaderImpl
import ru.yandex.kikimr.persqueue.consumer.SyncConsumer
import ru.yandex.kikimr.persqueue.consumer.transport.message.inbound.data.MessageBatch
import ru.yandex.monlib.metrics.registry.MetricRegistry
import java.util.*
import java.util.function.Supplier

class EcomDomainsPreviewsLogbrokerReader constructor(
    logbrokerConsumerSupplier: Supplier<SyncConsumer>,
    logbrokerNoCommit: Boolean,
    metricRegistry: MetricRegistry
) : LogbrokerBatchReaderImpl<Banner.TBanner>(logbrokerConsumerSupplier, logbrokerNoCommit, metricRegistry) {

    companion object {
        private val logger = LoggerFactory.getLogger(EcomDomainsPreviewsLogbrokerReader::class.java)
    }

    override fun batchDeserialize(messageBatch: MessageBatch): List<Banner.TBanner> {
        val data: MutableList<Banner.TBanner> = ArrayList()

        for (messageData in messageBatch.messageData) {
            val previewOffer: Banner.TBanner = try {
                Banner.TBanner.parseFrom(messageData.decompressedData)
            } catch (e: InvalidProtocolBufferException) {
                logger.error("Got error parsing message", e)
                continue
            }

            logger.info("Object - {}", TextFormat.shortDebugString(previewOffer))
            data.add(previewOffer)
        }

        return data
    }

    override fun count(e: List<Banner.TBanner>): Int {
        return e.size
    }
}
