package ru.yandex.direct.jobs.uac.model

import ru.yandex.direct.core.entity.uac.model.EcomDomain
import ru.yandex.direct.ytwrapper.model.YtField
import ru.yandex.direct.ytwrapper.model.YtTableRow

class LiveEcomDomainTableRow : YtTableRow(listOf(DOMAIN, SCHEMA, OFFERS_COUNT, SAMPLE)) {
    val domain: String
        get() = valueOf(DOMAIN)

    val schema: String
        get() = valueOf(SCHEMA)

    val offersCount: Long
        get() = valueOf(OFFERS_COUNT)

    val sample: String?
        get() = valueOf(SAMPLE)

    companion object {
        private val DOMAIN = YtField("domain", String::class.java)
        private val SCHEMA = YtField("schema", String::class.java)
        private val OFFERS_COUNT = YtField("offers_count", Long::class.java)
        private val SAMPLE = YtField("Sample", String::class.java)

        fun toEcomDomain(tableRow: LiveEcomDomainTableRow): EcomDomain = EcomDomain()
            .withDomain(tableRow.domain)
            .withSchema(tableRow.schema)
            .withOffersCount(tableRow.offersCount)
    }
}
